/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.bitbag;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import mod.chiselsandbits.bitbag.BagCapabilityProvider;
import mod.chiselsandbits.bitbag.BagStorage;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemChiseledBit;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class BagInventory
implements IInventory {
    BagStorage inv;
    ItemStack[] stackSlots;

    public BagInventory(ItemStack is) {
        this.inv = (BagStorage)is.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        this.stackSlots = new ItemStack[63];
        if (this.inv == null) {
            this.inv = new BagStorage();
            this.inv.stack = is;
            this.inv.setStorage(BagCapabilityProvider.getStorageArray(is, 126));
        }
        for (int x = 0; x < this.stackSlots.length; ++x) {
            this.stackSlots[x] = ModUtil.getEmptyStack();
        }
    }

    public ItemStack getItemStack() {
        return this.inv.stack;
    }

    public String func_70005_c_() {
        return "container.inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_70302_i_() {
        return this.stackSlots.length;
    }

    @Nonnull
    public ItemStack func_70301_a(int index) {
        int qty = this.inv.contents[2 * index + 1];
        int id = this.inv.contents[2 * index + 0];
        if (ModUtil.notEmpty(this.stackSlots[index])) {
            ItemStack which = ModUtil.nonNull(this.stackSlots[index]);
            ModUtil.setStackSize(which, qty);
            return which;
        }
        if (qty == 0 || id == 0) {
            return ModUtil.getEmptyStack();
        }
        this.stackSlots[index] = ItemChiseledBit.createStack(id, qty, false);
        return this.stackSlots[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        int qty = this.inv.contents[2 * index + 1];
        int id = this.inv.contents[2 * index + 0];
        if (qty == 0 || id == 0) {
            return ModUtil.getEmptyStack();
        }
        if (count > qty) {
            count = qty;
        }
        int n = 2 * index + 1;
        this.inv.contents[n] = this.inv.contents[n] - count;
        this.inv.onChange();
        if (ModUtil.notEmpty(this.stackSlots[index])) {
            ModUtil.adjustStackSize(ModUtil.nonNull(this.stackSlots[index]), -count);
        }
        return ItemChiseledBit.createStack(id, count, false);
    }

    public ItemStack func_70304_b(int index) {
        return ModUtil.getEmptyStack();
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.stackSlots[index] = ModUtil.getEmptyStack();
        if (stack != null && stack.func_77973_b() instanceof ItemChiseledBit) {
            this.inv.contents[2 * index + 1] = ModUtil.getStackSize(stack);
            this.inv.contents[2 * index + 0] = ItemChiseledBit.getStackState(stack);
        } else {
            this.inv.contents[2 * index + 1] = 0;
            this.inv.contents[2 * index + 0] = 0;
        }
        this.inv.onChange();
    }

    public int func_70297_j_() {
        return ChiselsAndBits.getConfig().bagStackSize;
    }

    public void func_70296_d() {
        for (int x = 0; x < this.func_70302_i_(); ++x) {
            if (!ModUtil.notEmpty(this.stackSlots[x])) continue;
            this.inv.contents[2 * x + 1] = ModUtil.getStackSize(this.stackSlots[x]);
            this.stackSlots[x] = ModUtil.getEmptyStack();
            this.inv.onChange();
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemChiseledBit;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void clear(ItemStack stack) {
        for (int x = 0; x < this.stackSlots.length; ++x) {
            if (!this.matches(stack, this.stackSlots[x])) continue;
            this.stackSlots[x] = ModUtil.getEmptyStack();
            this.inv.contents[x * 2 + 0] = 0;
            this.inv.contents[x * 2 + 1] = 0;
        }
        this.inv.onChange();
    }

    public boolean matches(ItemStack cmpStack, ItemStack invStack) {
        if (ModUtil.isEmpty(cmpStack) || invStack == null) {
            return true;
        }
        return cmpStack.func_77973_b() == invStack.func_77973_b() && ItemStack.func_77970_a((ItemStack)cmpStack, (ItemStack)invStack);
    }

    public ItemStack restockItem(ItemStack target, ItemStack targetType) {
        int outSize = ModUtil.getStackSize(target);
        for (int x = this.func_70302_i_() - 1; x >= 0; --x) {
            ItemStack is = this.func_70301_a(x);
            if (!ItemChiseledBit.sameBit(targetType, ItemChiseledBit.getStackState(is))) continue;
            outSize += ModUtil.getStackSize(is);
            int total = outSize;
            int overage = total - (outSize = Math.min(is.func_77976_d(), outSize));
            if (overage > 0) {
                ModUtil.setStackSize(is, overage);
            } else {
                this.func_70299_a(x, ModUtil.getEmptyStack());
            }
            this.func_70296_d();
        }
        ItemStack out = ModUtil.copy(targetType);
        ModUtil.setStackSize(out, outSize);
        return out;
    }

    @Nonnull
    public ItemStack insertItem(@Nonnull ItemStack which) {
        for (int x = 0; x < this.func_70302_i_(); ++x) {
            ItemStack is = this.func_70301_a(x);
            if (!ModUtil.isEmpty(is) && ItemChiseledBit.getStackState(which) == ItemChiseledBit.getStackState(is)) {
                ModUtil.adjustStackSize(is, ModUtil.getStackSize(which));
                int total = ModUtil.getStackSize(is);
                ModUtil.setStackSize(is, Math.min(this.func_70297_j_(), ModUtil.getStackSize(is)));
                int overage = total - ModUtil.getStackSize(is);
                if (overage > 0) {
                    ModUtil.setStackSize(which, overage);
                    this.func_70296_d();
                    continue;
                }
                this.func_70296_d();
                return ModUtil.getEmptyStack();
            }
            if (!ModUtil.isEmpty(is)) continue;
            this.func_70299_a(x, which);
            this.func_70296_d();
            return ModUtil.getEmptyStack();
        }
        return which;
    }

    public int extractBit(int bitMeta, int total) {
        int used = 0;
        for (int index = this.stackSlots.length - 1; index >= 0; --index) {
            int qty_idx = 2 * index + 1;
            int qty = this.inv.contents[qty_idx];
            int id = this.inv.contents[2 * index + 0];
            if (id != bitMeta || qty <= 0) continue;
            int n = qty_idx;
            this.inv.contents[n] = this.inv.contents[n] - total;
            if (this.inv.contents[qty_idx] < 0) {
                this.inv.contents[qty_idx] = 0;
            }
            this.inv.onChange();
            int diff = qty - this.inv.contents[qty_idx];
            used += diff;
            if (0 != (total -= diff)) continue;
            return used;
        }
        return used;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> listContents(List<String> details) {
        TreeMap<String, Integer> contents = new TreeMap<String, Integer>();
        for (int x = 0; x < this.func_70302_i_(); ++x) {
            String name;
            IBlockState iBlockState;
            ItemStack is = this.func_70301_a(x);
            if (ModUtil.isEmpty(is) || (iBlockState = ModUtil.getStateById(ItemChiseledBit.getStackState(is))) == null || (name = ItemChiseledBit.getBitStateName(iBlockState)) == null) continue;
            Integer count = (Integer)contents.get(name);
            count = count == null ? Integer.valueOf(ModUtil.getStackSize(is)) : Integer.valueOf(count + ModUtil.getStackSize(is));
            contents.put(name, count);
        }
        if (contents.isEmpty()) {
            details.add(LocalStrings.Empty.getLocal());
        }
        ArrayList list = new ArrayList();
        list.addAll(contents.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                int y = o1.getValue();
                int x = o2.getValue();
                return x < y ? -1 : (x == y ? 0 : 1);
            }
        });
        for (Map.Entry entry : list) {
            details.add(entry.getValue() + ' ' + (String)entry.getKey());
        }
        return details;
    }

    public void func_174888_l() {
        this.clear(null);
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.stackSlots) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }
}

