/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.java.proxies.ArrayJavaProxy;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyModule(name={"JavaArrayUtilities"})
public class JavaArrayUtilities {
    public static RubyModule createJavaArrayUtilitiesModule(Ruby runtime) {
        RubyModule javaArrayUtils = runtime.defineModule("JavaArrayUtilities");
        javaArrayUtils.defineAnnotatedMethods(JavaArrayUtilities.class);
        return javaArrayUtils;
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject bytes_to_ruby_string(ThreadContext context, IRubyObject recv2, IRubyObject wrappedObject) {
        return JavaArrayUtilities.bytes_to_ruby_string(context, recv2, wrappedObject, context.nil);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject bytes_to_ruby_string(ThreadContext context, IRubyObject recv2, IRubyObject wrappedObject, IRubyObject encoding2) {
        Ruby runtime = recv2.getRuntime();
        byte[] bytes2 = null;
        if (wrappedObject instanceof JavaProxy) {
            Object wrapped = ((JavaProxy)wrappedObject).getObject();
            if (wrapped instanceof byte[]) {
                bytes2 = (byte[])wrapped;
            }
        } else {
            IRubyObject byteArray = (IRubyObject)wrappedObject.dataGetStruct();
            if (byteArray instanceof JavaArray && ((JavaArray)byteArray).getValue() instanceof byte[]) {
                bytes2 = (byte[])((JavaArray)byteArray).getValue();
            }
        }
        if (bytes2 == null) {
            throw runtime.newTypeError("wrong argument type " + wrappedObject.getMetaClass() + " (expected byte[])");
        }
        RubyString string2 = runtime.newString(new ByteList(bytes2, true));
        if (!encoding2.isNil()) {
            string2.force_encoding(context, encoding2);
        }
        return string2;
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject ruby_string_to_bytes(IRubyObject recv2, IRubyObject string2) {
        Ruby runtime = recv2.getRuntime();
        if (!(string2 instanceof RubyString)) {
            throw runtime.newTypeError(string2, runtime.getString());
        }
        return JavaUtil.convertJavaToUsableRubyObject(runtime, ((RubyString)string2).getBytes());
    }

    @JRubyMethod(module=true)
    public static IRubyObject java_to_ruby(ThreadContext context, IRubyObject recv2, IRubyObject ary) {
        if (!(ary instanceof ArrayJavaProxy)) {
            throw context.runtime.newTypeError(ary, context.runtime.getJavaSupport().getArrayProxyClass());
        }
        return ((ArrayJavaProxy)ary).to_a(context);
    }
}

