/*
 * Decompiled with CFR 0.152.
 */
package mods.quiddity.redux.Engines.JavaScript;

import java.io.InputStream;
import java.io.InputStreamReader;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import mods.quiddity.redux.Engines.Engine;
import mods.quiddity.redux.Engines.ReduxAPI;
import mods.quiddity.redux.json.model.Pack;

public class ReduxJavascriptEngine
implements Engine {
    public static final ScriptEngineManager engineManager = new ScriptEngineManager();
    private ScriptEngine engine;
    private final Pack packRefrence;

    public ReduxJavascriptEngine(Pack pack2) {
        this.packRefrence = pack2;
    }

    @Override
    public void init() {
        if (engineManager.getEngineByName("nashorn") != null) {
            this.engine = engineManager.getEngineByName("nashorn");
        } else if (engineManager.getEngineByName("rhino") != null) {
            this.engine = engineManager.getEngineByName("rhino");
        } else if (engineManager.getEngineByName("javascript") != null) {
            this.engine = engineManager.getEngineByName("javascript");
        }
        if (this.engine == null) {
            throw new AssertionError((Object)"Your Java Runtime Environment does not have a JSR-223 Javascript runtime!");
        }
        this.addJavaObject("ReduxAPI", new ReduxAPI(this));
    }

    @Override
    public void loadScript(String scriptName, InputStream scriptInput) throws ScriptException {
        this.engine.eval(new InputStreamReader(scriptInput));
    }

    @Override
    public void killEngine() {
        this.engine = null;
    }

    @Override
    public void restartEngine() {
        this.init();
    }

    @Override
    public void addJavaObject(String name2, Object object) {
        this.engine.put(name2, object);
    }

    @Override
    public boolean respondsToMethod(String name2) {
        return this.globalObjectExists(name2);
    }

    @Override
    public boolean globalObjectExists(String name2) {
        return this.engine.get(name2) != null;
    }

    @Override
    public void callMethod(String name2, Object ... args2) throws ScriptException, NoSuchMethodException {
        if (!(this.engine instanceof Invocable)) {
            throw new AssertionError((Object)"Your Rhino engine cannot invoke javascript functions! Redux will not function.");
        }
        Invocable invokableEngine = (Invocable)((Object)this.engine);
        invokableEngine.invokeFunction(name2, args2);
    }

    @Override
    public Object getJavaObject(String name2, Class<?> javaType) {
        return this.engine.get(name2);
    }

    @Override
    public Pack getPackReference() {
        return this.packRefrence;
    }
}

