/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.io.IOException;
import java.net.URL;
import org.jruby.Ruby;
import org.jruby.runtime.load.ClassExtensionLibrary;
import org.jruby.runtime.load.Library;
import org.jruby.runtime.load.LoadServiceResource;

public class JarredScript
implements Library {
    private final LoadServiceResource resource;
    private final String searchName;

    public JarredScript(LoadServiceResource resource2, String searchName) {
        this.resource = resource2;
        this.searchName = searchName;
    }

    public LoadServiceResource getResource() {
        return this.resource;
    }

    @Override
    public void load(Ruby runtime, boolean wrap2) {
        try {
            URL jarFile = this.resource.getURL();
            runtime.getJRubyClassLoader().addURL(jarFile);
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
        ClassExtensionLibrary serviceExtension = ClassExtensionLibrary.tryFind(runtime, this.searchName);
        if (serviceExtension != null) {
            serviceExtension.load(runtime, wrap2);
        }
    }
}

