/*
 * Decompiled with CFR 0.152.
 */
package mods.quiddity.redux;

import mods.quiddity.redux.Redux;
import mods.quiddity.redux.json.model.Flags;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.spi.AbstractLogger;

public class ReduxLogger
extends AbstractLogger {
    private final String prefix;
    private int maxLogLevel = 3;
    public static final String LOG_LEVEL_CONFIG_KEY = "log_level";

    public ReduxLogger(String modName) {
        this.prefix = modName;
    }

    public void loadConfigLevel() {
        if (Redux.instance.getReduxConfiguration() != null) {
            Flags<String, ?> logLevel = Redux.instance.getReduxConfiguration().getFlagForName(LOG_LEVEL_CONFIG_KEY, new Flags<String, Integer>(LOG_LEVEL_CONFIG_KEY, 3));
            this.maxLogLevel = logLevel != null && logLevel.getValue() instanceof Integer ? ((Integer)logLevel.getValue()).intValue() : Level.WARN.intLevel();
        }
    }

    protected boolean isEnabled(Level level2, Marker marker, Message data2, Throwable t) {
        return level2.lessOrEqual(this.maxLogLevel);
    }

    protected boolean isEnabled(Level level2, Marker marker, Object data2, Throwable t) {
        return level2.lessOrEqual(this.maxLogLevel);
    }

    protected boolean isEnabled(Level level2, Marker marker, String data2) {
        return level2.lessOrEqual(this.maxLogLevel);
    }

    protected boolean isEnabled(Level level2, Marker marker, String data2, Object ... p1) {
        return level2.lessOrEqual(this.maxLogLevel);
    }

    protected boolean isEnabled(Level level2, Marker marker, String data2, Throwable t) {
        return level2.lessOrEqual(this.maxLogLevel);
    }

    public void log(Marker marker, String fqcn, Level level2, Message data2, Throwable t) {
        if (t != null) {
            t.printStackTrace(System.out.format("[%s] %s: %s. Throwable Exception:\n", level2.toString(), this.prefix, data2.getFormattedMessage()));
        } else {
            System.out.format("[%s] %s: %s. Caller: %s\n", level2.toString(), this.prefix, data2.getFormattedMessage(), fqcn);
        }
    }
}

