/*
 * Decompiled with CFR 0.152.
 */
package mods.quiddity.redux.Engines.Ruby;

import java.io.InputStream;
import javax.script.ScriptException;
import mods.quiddity.redux.Engines.Engine;
import mods.quiddity.redux.Engines.ReduxAPI;
import mods.quiddity.redux.json.model.Pack;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.ScriptingContainer;

public class ReduxJRubyEngine
implements Engine {
    private ScriptingContainer engineContainer;
    private Pack pack;

    public ReduxJRubyEngine(Pack pack) {
        this.pack = pack;
    }

    @Override
    public void init() {
        this.engineContainer = new ScriptingContainer(LocalContextScope.SINGLETON);
        this.addJavaObject("ReduxAPI", new ReduxAPI(this));
    }

    @Override
    public void loadScript(String scriptName, InputStream scriptInput) throws ScriptException {
        this.engineContainer.runScriptlet(scriptInput, scriptName);
    }

    @Override
    public void killEngine() {
        this.engineContainer.terminate();
    }

    @Override
    public void restartEngine() {
        this.engineContainer.terminate();
        this.init();
    }

    @Override
    public void addJavaObject(String name, Object object) {
        this.engineContainer.put(name, object);
    }

    @Override
    public boolean respondsToMethod(String name) {
        return this.engineContainer.getProvider().getRuntime().getTopSelf().respondsTo(name);
    }

    @Override
    public boolean globalObjectExists(String name) {
        return this.engineContainer.get(name) != null;
    }

    @Override
    public void callMethod(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        this.engineContainer.callMethod(null, name, args);
    }

    @Override
    public Object getJavaObject(String name, Class<?> javaType) {
        Object javaObject = this.engineContainer.get(name);
        if (!javaType.isAssignableFrom(javaObject.getClass())) {
            return null;
        }
        return javaObject;
    }

    @Override
    public Pack getPackReference() {
        return this.pack;
    }
}

