/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.cext.ModuleLoader;
import org.jruby.runtime.load.Library;
import org.jruby.runtime.load.LoadServiceResource;

public class CExtension
implements Library {
    private LoadServiceResource resource;

    public CExtension(LoadServiceResource resource2) {
        this.resource = resource2;
    }

    @Override
    public void load(Ruby runtime, boolean wrap2) throws IOException {
        String file2;
        if (!this.resource.getURL().getProtocol().equals("jar")) {
            file2 = this.resource.getAbsolutePath();
        } else {
            InputStream is = this.resource.getInputStream();
            FileOutputStream os = null;
            File dstFile = new File(System.getProperty("java.io.tmpdir") + File.pathSeparator + this.resource.getName());
            if (!dstFile.exists()) {
                try {
                    dstFile.deleteOnExit();
                    os = new FileOutputStream(dstFile);
                    ReadableByteChannel srcChannel = Channels.newChannel(is);
                    long pos2 = 0L;
                    while (is.available() > 0) {
                        pos2 += os.getChannel().transferFrom(srcChannel, pos2, Math.max(4096, is.available()));
                    }
                }
                catch (IOException ex) {
                    throw runtime.newLoadError("Error loading file -- " + this.resource.getName());
                }
                finally {
                    try {
                        if (os != null) {
                            os.close();
                        }
                        is.close();
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
            file2 = dstFile.getAbsolutePath();
        }
        ModuleLoader.load(runtime, file2);
        RubyInstanceConfig.setLoadedNativeExtensions(true);
    }
}

