/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.embed.variable.BiVariable;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

abstract class AbstractVariable
implements BiVariable {
    protected final IRubyObject receiver;
    protected String name;
    protected Object javaObject = null;
    protected Class javaType = null;
    protected IRubyObject irubyObject = null;
    protected boolean fromRuby;

    protected AbstractVariable(RubyObject receiver2, String name2, boolean fromRuby) {
        this.receiver = receiver2;
        this.name = name2;
        this.fromRuby = fromRuby;
    }

    protected void updateByJavaObject(Ruby runtime, Object ... values2) {
        assert (values2 != null);
        this.javaObject = values2[0];
        this.javaType = this.javaObject == null ? null : (values2.length > 1 ? (Class)values2[1] : this.javaObject.getClass());
        this.irubyObject = JavaEmbedUtils.javaToRuby(runtime, this.javaObject);
        this.fromRuby = false;
    }

    protected AbstractVariable(IRubyObject receiver2, String name2, boolean fromRuby, IRubyObject rubyObject) {
        this.receiver = receiver2;
        this.name = name2;
        this.fromRuby = fromRuby;
        this.irubyObject = rubyObject;
    }

    protected void updateRubyObject(IRubyObject rubyObject) {
        if (rubyObject == null) {
            return;
        }
        this.irubyObject = rubyObject;
    }

    @Override
    public IRubyObject getReceiver() {
        return this.receiver;
    }

    @Override
    public boolean isReceiverIdentical(RubyObject recv2) {
        return this.receiver == recv2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getJavaObject() {
        if (this.irubyObject == null) {
            return this.javaObject;
        }
        Ruby rt = this.irubyObject.getRuntime();
        if (this.javaType != null) {
            this.javaObject = this.javaType.cast(this.irubyObject.toJava(this.javaType));
        } else {
            this.javaObject = this.irubyObject.toJava(Object.class);
            if (this.javaObject != null) {
                this.javaType = this.javaObject.getClass();
            }
        }
        return this.javaObject;
    }

    @Override
    public void setJavaObject(Ruby runtime, Object javaObject) {
        this.updateByJavaObject(runtime, javaObject);
    }

    @Override
    public IRubyObject getRubyObject() {
        return this.irubyObject;
    }

    @Override
    public void setRubyObject(IRubyObject rubyObject) {
        this.updateRubyObject(rubyObject);
    }

    protected RubyModule getRubyClass(Ruby runtime) {
        ThreadContext context = runtime.getCurrentContext();
        StaticScope scope = context.getCurrentScope().getStaticScope();
        RubyModule rubyClass = scope.getModule();
        return rubyClass;
    }

    protected static boolean isValidName(String pattern, Object name2) {
        if (!(name2 instanceof String)) {
            return false;
        }
        return ((String)name2).matches(pattern);
    }
}

