/*
 * Decompiled with CFR 0.152.
 */
package mods.quiddity.redux;

import java.lang.reflect.Field;
import javax.script.ScriptException;
import mods.quiddity.redux.Redux;
import mods.quiddity.redux.json.model.Pack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ReduxEventDispatcher {
    private static ReduxEventDispatcher ourInstance = null;

    public static ReduxEventDispatcher getInstance() {
        if (ourInstance == null) {
            ourInstance = new ReduxEventDispatcher();
        }
        return ourInstance;
    }

    private ReduxEventDispatcher() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onEvent(Event event) {
        if (FMLCommonHandler.instance().getMinecraftServerInstance() != null && FMLCommonHandler.instance().getMinecraftServerInstance().isCallingFromMinecraftThread()) {
            for (Pack p : Redux.instance.getReduxConfiguration().getPacks()) {
                Field worldField;
                if (!p.getEngine().respondsToMethod(event.getClass().getSimpleName())) continue;
                try {
                    if (event.getClass().getField("world") != null) {
                        worldField = event.getClass().getField("world");
                        worldField.setAccessible(true);
                        p.getEngine().addJavaObject("world", worldField.get(event));
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                try {
                    if (event.getClass().getField("entity") != null) {
                        worldField = event.getClass().getField("entity");
                        worldField.setAccessible(true);
                        p.getEngine().addJavaObject("entity", worldField.get(event));
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                try {
                    if (event.getClass().getField("pos") != null) {
                        worldField = event.getClass().getField("pos");
                        worldField.setAccessible(true);
                        p.getEngine().addJavaObject("pos", worldField.get(event));
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                try {
                    p.getEngine().callMethod(event.getClass().getSimpleName(), event);
                }
                catch (ScriptException e) {
                    Redux.instance.getLogger().warn("Redux pack inconsistency. A script file in pack: %s has errors.", new Object[]{p.getName()});
                }
                catch (NoSuchMethodException e) {
                    Redux.instance.getLogger().warn("Redux pack inconsistency. A script file in pack: %s has errors.", new Object[]{p.getName()});
                }
            }
        }
    }
}

