/*
 * Decompiled with CFR 0.152.
 */
package mods.quiddity.redux.json.model;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mods.quiddity.redux.json.model.Block;
import mods.quiddity.redux.json.model.Item;

public class Pack {
    @Nonnull
    protected String id;
    @Nonnull
    protected String name;
    @Nullable
    protected String author;
    @Nullable
    protected String description;
    @Nullable
    protected transient List<Block> block_list;
    @Nullable
    protected List<Item> item_list;
    private transient Map<String, Block> idMap = null;
    private transient boolean hasAddedBlocks = false;

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public List<Block> getBlocks() {
        return this.block_list == null ? null : this.block_list;
    }

    public void setBlockList(List<Block> blocks) {
        if (!this.hasAddedBlocks) {
            this.block_list = ImmutableList.copyOf(blocks);
            this.hasAddedBlocks = true;
        }
    }

    public Block getBlockFromId(String id) {
        if (this.getBlocks() == null || id == null) {
            return null;
        }
        if (this.idMap == null) {
            this.idMap = new HashMap<String, Block>();
            for (Block b : this.getBlocks()) {
                this.idMap.put(b.getId(), b);
            }
        }
        return this.idMap.get(id);
    }

    public List<Item> getItems() {
        return this.item_list == null ? null : ImmutableList.copyOf(this.item_list);
    }

    public String getAuthor() {
        return this.author;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.getName();
    }
}

