/*
 * Decompiled with CFR 0.152.
 */
package mods.quiddity.redux.json.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mods.quiddity.redux.json.model.Flags;
import mods.quiddity.redux.json.model.Trigger;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;

public class Block {
    @Nonnull
    private String id;
    @Nonnull
    private String name;
    @Nonnull
    private String description;
    @Nonnull
    private String material;
    @Nullable
    private boolean full_cube;
    @Nullable
    private boolean is_weak;
    @Nullable
    private List<CollisionBox> collisionBoxes;
    @Nullable
    private boolean directional;
    @Nullable
    private List<Flags<String, Integer>> custom_properties;
    @Nullable
    private List<String> ignored_properties;
    @Nullable
    private String redstone_output_property;
    @Nullable
    private String creative_tab;
    @Nullable
    private String creative_tab_icon;
    @Nullable
    private int tick_rate;
    @Nullable
    private List<String> ore_dictionary;
    @Nullable
    private List<Trigger> script;
    private transient CreativeTabs creativeTabObject = null;

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    public String getId() {
        return this.id;
    }

    public int getTickRate() {
        return this.tick_rate;
    }

    public boolean tickable() {
        return this.tick_rate > 0;
    }

    public Material getMaterial() {
        try {
            return (Material)Material.class.getField(this.material).get(null);
        }
        catch (Exception e) {
            return Material.air;
        }
    }

    public boolean shouldAddFacingProperty() {
        return this.directional;
    }

    public List<CollisionBox> getCollisionBoxes() {
        if (this.collisionBoxes != null) {
            return ImmutableList.copyOf(this.collisionBoxes);
        }
        return null;
    }

    public boolean hasMultipleCollisionBoxes() {
        return this.collisionBoxes != null && this.collisionBoxes.size() > 1;
    }

    public boolean isFullCube() {
        return this.full_cube;
    }

    public boolean isWeak() {
        return this.is_weak;
    }

    public CreativeTabs getCreativeTab() {
        if (this.creative_tab == null || this.creative_tab.isEmpty()) {
            this.creativeTabObject = CreativeTabs.tabAllSearch;
            return this.creativeTabObject;
        }
        if (this.creativeTabObject == null) {
            for (CreativeTabs tab : CreativeTabs.creativeTabArray) {
                if (!tab.getTabLabel().equalsIgnoreCase(this.creative_tab)) continue;
                this.creativeTabObject = tab;
            }
            if (this.creativeTabObject == null) {
                this.creativeTabObject = new CreativeTabs(this.creative_tab){

                    public Item getTabIconItem() {
                        return Block.this.creative_tab_icon == null || Block.this.creative_tab_icon.isEmpty() || Item.getByNameOrId((String)Block.this.creative_tab_icon) == null ? ItemBlock.getItemFromBlock((net.minecraft.block.Block)Blocks.air) : Item.getByNameOrId((String)Block.this.creative_tab_icon);
                    }
                };
            }
        }
        return this.creativeTabObject;
    }

    public List<Trigger> getScript() {
        return ImmutableList.copyOf(this.script);
    }

    public List<String> getOreDictionaryNames() {
        return ImmutableList.copyOf(this.ore_dictionary);
    }

    public List<Flags<String, Integer>> getCustomProperties() {
        if (this.custom_properties == null) {
            return null;
        }
        return ImmutableList.copyOf(this.custom_properties);
    }

    public List<String> getIgnoredProperties() {
        if (this.ignored_properties == null) {
            return null;
        }
        return ImmutableList.copyOf(this.ignored_properties);
    }

    public String getRedstoneOutputProperty() {
        return this.redstone_output_property == null ? "" : this.redstone_output_property;
    }

    public String toString() {
        return this.id + " - " + this.description;
    }

    public class CollisionBox {
        private float minX;
        private float minY;
        private float minZ;
        private float maxX;
        private float maxY;
        private float maxZ;

        public float getMinX() {
            return this.minX;
        }

        public float getMinY() {
            return this.minY;
        }

        public float getMinZ() {
            return this.minZ;
        }

        public float getMaxX() {
            return this.maxX;
        }

        public float getMaxY() {
            return this.maxY;
        }

        public float getMaxZ() {
            return this.maxZ;
        }
    }
}

