/*
 * Decompiled with CFR 0.152.
 */
package mods.quiddity.redux;

import com.google.common.base.Predicate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mods.quiddity.redux.ReduxCommandBlockTickableTileEntity;
import mods.quiddity.redux.ReduxCommandBlockTileEntity;
import mods.quiddity.redux.json.model.Block;
import mods.quiddity.redux.json.model.Flags;
import mods.quiddity.redux.json.model.Pack;
import mods.quiddity.redux.json.model.Trigger;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class ReduxBlock
extends net.minecraft.block.Block
implements ITileEntityProvider {
    private final Pack pack;
    private final Block reduxBlock;
    public static final PropertyInteger SUCCESS_COUNT_META = PropertyInteger.func_177719_a((String)"lastSuccessCount", (int)0, (int)15);
    public static final ThreadLocal<Block> blockThreadLocal = new ThreadLocal();
    private final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private Map<String, PropertyInteger> customBlockProperties = new HashMap<String, PropertyInteger>();

    public ReduxBlock(Pack parentPack, Block reduxBlock) {
        super(reduxBlock.getMaterial());
        this.pack = parentPack;
        this.reduxBlock = reduxBlock;
        this.func_149663_c(reduxBlock.getName());
        this.func_149647_a(reduxBlock.getCreativeTab());
        IBlockState defaultBlockState = this.field_176227_L.func_177621_b().func_177226_a((IProperty)SUCCESS_COUNT_META, (Comparable)Integer.valueOf(0));
        if (reduxBlock.shouldAddFacingProperty()) {
            defaultBlockState = defaultBlockState.func_177226_a((IProperty)this.FACING, null);
        }
        if (reduxBlock.getCustomProperties() != null) {
            for (Flags<String, Integer> customProperty : reduxBlock.getCustomProperties()) {
                PropertyInteger customIntegerProperty = PropertyInteger.func_177719_a((String)customProperty.getKey(), (int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE);
                this.customBlockProperties.put(customProperty.getKey(), customIntegerProperty);
                defaultBlockState = defaultBlockState.func_177226_a((IProperty)customIntegerProperty, (Comparable)customProperty.getValue());
            }
        }
        this.func_180632_j(defaultBlockState);
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            StateMap.Builder stateMapBuilder = new StateMap.Builder().func_178442_a(new IProperty[]{SUCCESS_COUNT_META});
            if (reduxBlock.getIgnoredProperties() != null) {
                for (String s : reduxBlock.getIgnoredProperties()) {
                    PropertyInteger propertyInteger = this.customBlockProperties.get(s);
                    if (propertyInteger == null) continue;
                    stateMapBuilder.func_178442_a(new IProperty[]{propertyInteger});
                }
            }
            FMLClientHandler.instance().getClient().func_175602_ab().func_175023_a().func_178121_a((net.minecraft.block.Block)this, (IStateMapper)stateMapBuilder.func_178441_a());
        }
    }

    public void func_180638_a(World worldIn, BlockPos pos, IBlockState state, AxisAlignedBB mask, List list, Entity collidingEntity) {
        if (!this.reduxBlock.hasMultipleCollisionBoxes()) {
            super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
        } else {
            for (Block.CollisionBox collisionBox : this.reduxBlock.getCollisionBoxes()) {
                this.func_149676_a(collisionBox.getMinX(), collisionBox.getMinY(), collisionBox.getMinZ(), collisionBox.getMaxX(), collisionBox.getMaxY(), collisionBox.getMaxZ());
                super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
            }
            this.func_149683_g();
        }
    }

    public boolean func_149703_v() {
        return this.reduxBlock.getCollisionBoxes() != null && this.reduxBlock.getCollisionBoxes().isEmpty();
    }

    public boolean hasTileEntity(IBlockState state) {
        return this.reduxBlock.tickable() || !this.reduxBlock.getScript().isEmpty();
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        if (worldIn.func_175625_s(pos) instanceof ReduxCommandBlockTileEntity) {
            ReduxCommandBlockTileEntity commandBlockTileEntity = (ReduxCommandBlockTileEntity)worldIn.func_175625_s(pos);
            commandBlockTileEntity.triggerSpecialEvent(Trigger.TriggerEvent.OnEntityCollide, entityIn);
        }
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return this.func_149915_a(world, 0);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        ReduxCommandBlockTileEntity te = null;
        if (this.reduxBlock.tickable()) {
            te = new ReduxCommandBlockTickableTileEntity();
        } else if (!this.reduxBlock.getScript().isEmpty()) {
            te = new ReduxCommandBlockTileEntity();
        }
        if (te != null) {
            te.init(this.pack.getId(), this.reduxBlock);
        }
        return te;
    }

    public boolean func_149740_M() {
        return this.hasTileEntity(null);
    }

    public int func_180641_l(World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity instanceof ReduxCommandBlockTileEntity ? (((ReduxCommandBlockTileEntity)tileentity).getLastSuccessCount() > 15 ? 15 : ((ReduxCommandBlockTileEntity)tileentity).getLastSuccessCount()) : 0;
    }

    public PropertyInteger getPropertyFromName(String name) {
        return this.customBlockProperties.get(name);
    }

    public int func_176201_c(IBlockState state) {
        if (this.hasTileEntity(state) && !state.func_177227_a().isEmpty()) {
            return (Integer)state.func_177229_b((IProperty)SUCCESS_COUNT_META);
        }
        return 0;
    }

    public Class<? extends ReduxCommandBlockTileEntity> getTileEntityClass() {
        if (this.reduxBlock.tickable()) {
            return ReduxCommandBlockTickableTileEntity.class;
        }
        if (!this.reduxBlock.getScript().isEmpty()) {
            return ReduxCommandBlockTileEntity.class;
        }
        return null;
    }

    protected BlockState func_180661_e() {
        Block reduxBlock = this.reduxBlock == null ? blockThreadLocal.get() : this.reduxBlock;
        if (reduxBlock == null) {
            throw new AssertionError();
        }
        if (reduxBlock.shouldAddFacingProperty()) {
            return new BlockState((net.minecraft.block.Block)this, new IProperty[]{SUCCESS_COUNT_META, this.FACING});
        }
        return new BlockState((net.minecraft.block.Block)this, new IProperty[]{SUCCESS_COUNT_META});
    }

    public boolean func_149662_c() {
        Block reduxBlock = this.reduxBlock == null ? blockThreadLocal.get() : this.reduxBlock;
        if (reduxBlock == null) {
            throw new AssertionError();
        }
        return reduxBlock.isFullCube();
    }

    public boolean func_149686_d() {
        Block reduxBlock = this.reduxBlock == null ? blockThreadLocal.get() : this.reduxBlock;
        if (reduxBlock == null) {
            throw new AssertionError();
        }
        return reduxBlock.isFullCube();
    }

    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, net.minecraft.block.Block neighborBlock) {
        if (!worldIn.field_72995_K && !this.func_176196_c(worldIn, pos) && this.reduxBlock.isWeak()) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return this.reduxBlock.isWeak() ? World.func_175683_a((IBlockAccess)worldIn, (BlockPos)pos.func_177977_b()) || worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150426_aN : super.func_176196_c(worldIn, pos);
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        if (worldIn.func_175625_s(pos) instanceof ReduxCommandBlockTileEntity) {
            ReduxCommandBlockTileEntity commandBlockTileEntity = (ReduxCommandBlockTileEntity)worldIn.func_175625_s(pos);
            commandBlockTileEntity.triggerSpecialEvent(Trigger.TriggerEvent.OnEntityCollide, false, playerIn);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.func_175625_s(pos) instanceof ReduxCommandBlockTileEntity) {
            ReduxCommandBlockTileEntity commandBlockTileEntity = (ReduxCommandBlockTileEntity)worldIn.func_175625_s(pos);
            return commandBlockTileEntity.triggerSpecialEvent(Trigger.TriggerEvent.OnEntityCollide, true, playerIn, side, Float.valueOf(hitX), Float.valueOf(hitY), Float.valueOf(hitZ));
        }
        return false;
    }

    public boolean func_149744_f() {
        return this.reduxBlock.getRedstoneOutputProperty() != null && !this.reduxBlock.getRedstoneOutputProperty().isEmpty();
    }

    public int func_180656_a(IBlockAccess worldIn, BlockPos pos, IBlockState state, EnumFacing side) {
        if (this.customBlockProperties.get(this.reduxBlock.getRedstoneOutputProperty()) != null) {
            PropertyInteger redstoneProperty = this.customBlockProperties.get(this.reduxBlock.getRedstoneOutputProperty());
            return (Integer)state.func_177229_b((IProperty)redstoneProperty) > 15 ? 15 : (Integer)state.func_177229_b((IProperty)redstoneProperty);
        }
        return 0;
    }

    public int func_176211_b(IBlockAccess worldIn, BlockPos pos, IBlockState state, EnumFacing side) {
        if (this.customBlockProperties.get(this.reduxBlock.getRedstoneOutputProperty()) != null) {
            PropertyInteger redstoneProperty = this.customBlockProperties.get(this.reduxBlock.getRedstoneOutputProperty());
            return (Integer)state.func_177229_b((IProperty)redstoneProperty) > 15 ? 15 : (Integer)state.func_177229_b((IProperty)redstoneProperty);
        }
        return 0;
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }
}

