/*
 * Decompiled with CFR 0.152.
 */
package mods.quiddity.redux;

import com.google.common.base.Predicate;
import java.util.HashMap;
import java.util.Map;
import mods.quiddity.redux.ReduxCommandBlockTickableTileEntity;
import mods.quiddity.redux.ReduxCommandBlockTileEntity;
import mods.quiddity.redux.json.model.Block;
import mods.quiddity.redux.json.model.Flags;
import mods.quiddity.redux.json.model.Pack;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class ReduxBlock
extends net.minecraft.block.Block
implements ITileEntityProvider {
    private final Pack pack;
    private final Block reduxBlock;
    public static final PropertyInteger SUCCESS_COUNT_META = PropertyInteger.create((String)"lastSuccessCount", (int)0, (int)15);
    private final PropertyDirection FACING = PropertyDirection.create((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private Map<String, PropertyInteger> customBlockProperties = new HashMap<String, PropertyInteger>();

    public ReduxBlock(Pack parentPack, Block reduxBlock) {
        super(reduxBlock.getMaterial());
        this.setUnlocalizedName(reduxBlock.getName());
        this.setCreativeTab(reduxBlock.getCreativeTab());
        this.pack = parentPack;
        this.reduxBlock = reduxBlock;
        IBlockState defaultBlockState = this.blockState.getBaseState().withProperty((IProperty)SUCCESS_COUNT_META, (Comparable)Integer.valueOf(0));
        if (reduxBlock.shouldAddFacingProperty()) {
            defaultBlockState = defaultBlockState.withProperty((IProperty)this.FACING, null);
        }
        for (Flags<String, Integer> customProperty : reduxBlock.getCustomProperties()) {
            PropertyInteger customIntegerProperty = PropertyInteger.create((String)customProperty.getKey(), (int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE);
            this.customBlockProperties.put(customProperty.getKey(), customIntegerProperty);
            defaultBlockState = defaultBlockState.withProperty((IProperty)customIntegerProperty, (Comparable)customProperty.getValue());
        }
        this.setDefaultState(defaultBlockState);
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            StateMap.Builder stateMapBuilder = new StateMap.Builder().addPropertiesToIgnore(new IProperty[]{SUCCESS_COUNT_META});
            FMLClientHandler.instance().getClient().getBlockRendererDispatcher().getBlockModelShapes().registerBlockWithStateMapper((net.minecraft.block.Block)this, (IStateMapper)stateMapBuilder.build());
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return this.reduxBlock.tickable() || !this.reduxBlock.getScript().isEmpty();
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return this.createNewTileEntity(world, 0);
    }

    public TileEntity createNewTileEntity(World worldIn, int meta) {
        ReduxCommandBlockTileEntity te = null;
        if (this.reduxBlock.tickable()) {
            te = new ReduxCommandBlockTickableTileEntity();
        } else if (!this.reduxBlock.getScript().isEmpty()) {
            te = new ReduxCommandBlockTileEntity();
        }
        if (te != null) {
            te.init(this.pack.getId(), this.reduxBlock);
        }
        return te;
    }

    public boolean hasComparatorInputOverride() {
        return this.hasTileEntity(null);
    }

    public int getComparatorInputOverride(World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.getTileEntity(pos);
        return tileentity instanceof ReduxCommandBlockTileEntity ? ((ReduxCommandBlockTileEntity)tileentity).getLastSuccessCount() : 0;
    }

    public PropertyInteger getPropertyFromName(String name) {
        return this.customBlockProperties.get(name);
    }

    public int getMetaFromState(IBlockState state) {
        if (this.hasTileEntity(state) && !state.getPropertyNames().isEmpty()) {
            return (Integer)state.getValue((IProperty)SUCCESS_COUNT_META);
        }
        return 0;
    }

    public Class<? extends ReduxCommandBlockTileEntity> getTileEntityClass() {
        if (this.reduxBlock.tickable()) {
            return ReduxCommandBlockTickableTileEntity.class;
        }
        if (!this.reduxBlock.getScript().isEmpty()) {
            return ReduxCommandBlockTileEntity.class;
        }
        return null;
    }

    protected BlockState createBlockState() {
        if (this.reduxBlock.shouldAddFacingProperty()) {
            return new BlockState((net.minecraft.block.Block)this, new IProperty[]{SUCCESS_COUNT_META, this.FACING});
        }
        return new BlockState((net.minecraft.block.Block)this, new IProperty[]{SUCCESS_COUNT_META});
    }

    public boolean isOpaqueCube() {
        return !this.reduxBlock.isFullCube();
    }

    public boolean isFullCube() {
        return !this.reduxBlock.isFullCube();
    }

    public int getRenderType() {
        return this.reduxBlock.isFullCube() ? super.getRenderType() : 0;
    }
}

