/*
 * Decompiled with CFR 0.152.
 */
package mods.quiddity.redux.json.model;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mods.quiddity.redux.Redux;
import mods.quiddity.redux.json.JSONSingleton;
import mods.quiddity.redux.json.model.Flags;
import mods.quiddity.redux.json.model.Pack;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

public class Config {
    private List<Flags<String, ?>> features;
    private List<String> packs;
    private transient List<String> humanPackNames;
    private transient Map<Pack, File> packSourceFileMap;
    private transient Map<String, Pack> idToPack;

    public List<Pack> getPacks() {
        ArrayList<Pack> parsedPacks = new ArrayList<Pack>();
        this.humanPackNames = new ArrayList<String>();
        this.packSourceFileMap = new HashMap<Pack, File>();
        this.idToPack = new HashMap<String, Pack>();
        for (String pack : this.packs) {
            File file = null;
            Pack p = null;
            if (new File(Redux.reduxFolder, pack + File.separator + "config.json").exists()) {
                file = new File(Redux.reduxFolder, pack + File.separator + "config.json");
                try {
                    p = (Pack)JSONSingleton.getInstance().loadJSON(file, Pack.class);
                    if (p == null) {
                        Redux.instance.getLogger().warn("Enabled Redux pack config file not found. % s does not exist.", new Object[]{Redux.reduxFolder.getAbsolutePath() + pack + File.separator + "config.json"});
                    }
                }
                catch (JSONSingleton.JSONLoadException e) {
                    Redux.instance.getLogger().warn("Enabled Redux pack inconsistency. %s is inconsistent. Check the configuration.", new Object[]{pack + ".zip"});
                    Redux.instance.getLogger().warn((Message)new FormattedMessage("Redux pack %s will not be loaded.", (Object)pack, (Object)e));
                }
            } else if (new File(Redux.reduxFolder, pack + ".zip").exists()) {
                file = new File(Redux.reduxFolder, pack + ".zip");
                try {
                    ZipFile packZip = new ZipFile(file);
                    ZipArchiveEntry packConfig = packZip.getEntry("config.json");
                    if (packConfig != null) {
                        InputStreamReader packZipReader = new InputStreamReader(packZip.getInputStream(packConfig));
                        p = (Pack)JSONSingleton.getInstance().loadJSON(packZipReader, Pack.class);
                    }
                    packZip.close();
                }
                catch (Exception e) {
                    Redux.instance.getLogger().warn("Enabled Redux pack inconsistency. %s is inconsistent. Check the configuration.", new Object[]{pack + ".zip"});
                    Redux.instance.getLogger().warn((Message)new FormattedMessage("Redux pack %s will not be loaded.", (Object)pack, (Object)e));
                }
            }
            if (p == null) continue;
            parsedPacks.add(p);
            this.humanPackNames.add(p.getName());
            this.packSourceFileMap.put(p, file);
            this.idToPack.put(p.getId(), p);
        }
        return ImmutableList.copyOf(parsedPacks);
    }

    public List<String> getPackNames() {
        if (this.humanPackNames == null) {
            this.getPacks();
        }
        return ImmutableList.copyOf(this.humanPackNames);
    }

    public File getSourceForPack(Pack p) {
        if (this.packSourceFileMap == null) {
            this.getPacks();
        }
        return this.packSourceFileMap.get(p);
    }

    public Pack getPackFromId(String id) {
        return this.idToPack.get(id);
    }

    public List<Flags<String, ?>> getFeatures() {
        return ImmutableList.copyOf(this.features);
    }

    public Flags<String, ?> getFlagForName(String key) {
        return this.getFlagForName(key, null);
    }

    public Flags<String, ?> getFlagForName(String key, Flags<String, ?> defaultValue) {
        for (Flags flag : ImmutableList.copyOf(this.features)) {
            if (!((String)flag.getKey()).equalsIgnoreCase(key)) continue;
            return flag;
        }
        return defaultValue;
    }

    public String toString() {
        StringBuilder string = new StringBuilder("Enabled Packs: [");
        for (String s : this.getPackNames()) {
            string.append(s);
            string.append(',');
        }
        string.replace(string.lastIndexOf(","), string.lastIndexOf(","), "]");
        return string.toString();
    }
}

