/*
 * Decompiled with CFR 0.152.
 */
package mods.quiddity.redux;

import mods.quiddity.redux.ReduxCommandBlockTickableTileEntity;
import mods.quiddity.redux.ReduxCommandBlockTileEntity;
import mods.quiddity.redux.json.model.Block;
import mods.quiddity.redux.json.model.Pack;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class ReduxBlock
extends net.minecraft.block.Block
implements ITileEntityProvider {
    private final Pack pack;
    private final Block reduxBlock;
    public static final PropertyInteger SUCCESS_COUNT_META = PropertyInteger.func_177719_a((String)"lastSuccessCount", (int)0, (int)15);

    public ReduxBlock(Pack parentPack, Block reduxBlock) {
        super(reduxBlock.getMaterial());
        this.func_149663_c(reduxBlock.getName());
        this.func_149647_a(reduxBlock.getCreativeTab());
        this.pack = parentPack;
        this.reduxBlock = reduxBlock;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)SUCCESS_COUNT_META, (Comparable)Integer.valueOf(0)));
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            FMLClientHandler.instance().getClient().func_175602_ab().func_175023_a().func_178121_a((net.minecraft.block.Block)this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{SUCCESS_COUNT_META}).func_178441_a());
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return this.reduxBlock.tickable() || !this.reduxBlock.getScript().isEmpty();
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return this.func_149915_a(world, 0);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        ReduxCommandBlockTileEntity te = null;
        if (this.reduxBlock.tickable()) {
            te = new ReduxCommandBlockTickableTileEntity();
        } else if (!this.reduxBlock.getScript().isEmpty()) {
            te = new ReduxCommandBlockTileEntity();
        }
        if (te != null) {
            te.init(this.pack.getId(), this.reduxBlock);
        }
        return te;
    }

    public boolean func_149740_M() {
        return this.hasTileEntity(null);
    }

    public int func_180641_l(World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity instanceof ReduxCommandBlockTileEntity ? ((ReduxCommandBlockTileEntity)tileentity).getLastSuccessCount() : 0;
    }

    public int func_176201_c(IBlockState state) {
        if (this.hasTileEntity(state) && !state.func_177227_a().isEmpty()) {
            return (Integer)state.func_177229_b((IProperty)SUCCESS_COUNT_META);
        }
        return 0;
    }

    public Class<? extends ReduxCommandBlockTileEntity> getTileEntityClass() {
        if (this.reduxBlock.tickable()) {
            return ReduxCommandBlockTickableTileEntity.class;
        }
        if (!this.reduxBlock.getScript().isEmpty()) {
            return ReduxCommandBlockTileEntity.class;
        }
        return null;
    }

    protected BlockState func_180661_e() {
        return new BlockState((net.minecraft.block.Block)this, new IProperty[]{SUCCESS_COUNT_META});
    }
}

