/*
 * Decompiled with CFR 0.152.
 */
package dnoved1.immersify.api.property;

import dnoved1.immersify.api.property.Property;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class PropertyCompound<T>
extends Property<T[]> {
    public PropertyCompound(String name, T[] value) {
        super(name, value);
    }

    public PropertyCompound(String name, T[] value, int comparable) {
        super(name, value, comparable);
    }

    @Override
    public boolean equals(Object o) {
        Object[] otherValue;
        if (!super.equals(o)) {
            return false;
        }
        PropertyCompound p = (PropertyCompound)o;
        Object[] myValue = (Object[])this.getValue();
        if (myValue.length != (otherValue = (Object[])p.getValue()).length) {
            return false;
        }
        for (int i = 0; i < myValue.length; ++i) {
            if (myValue[i].equals(otherValue[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(Property<T[]> p) {
        T[] otherValue;
        if (p == null) {
            throw new NullPointerException();
        }
        Object[] myValue = (Object[])this.getValue();
        if (myValue.length != (otherValue = p.getValue()).length) {
            return -2;
        }
        for (int i = 0; i < myValue.length; ++i) {
            if (myValue[i].equals(otherValue[i])) continue;
            return -2;
        }
        return 0;
    }

    @Override
    public NBTBase convertToNBT() {
        Object[] myValue = (Object[])this.getValue();
        if (myValue.length == 0) {
            return null;
        }
        if (myValue.length == 1) {
            return this.convertTToNBT(myValue[0]);
        }
        NBTTagCompound nbtCompound = new NBTTagCompound(this.getName());
        for (Object value : myValue) {
            nbtCompound.func_74782_a("", this.convertTToNBT(value));
        }
        return nbtCompound;
    }

    private NBTBase convertTToNBT(T value) {
        if (value instanceof Byte) {
            return new NBTTagByte(this.getName(), ((Byte)value).byteValue());
        }
        if (value instanceof Short) {
            return new NBTTagShort(this.getName(), ((Short)value).shortValue());
        }
        if (value instanceof Integer) {
            return new NBTTagInt(this.getName(), ((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return new NBTTagLong(this.getName(), ((Long)value).longValue());
        }
        if (value instanceof Float) {
            return new NBTTagFloat(this.getName(), ((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return new NBTTagDouble(this.getName(), ((Double)value).doubleValue());
        }
        if (value instanceof String) {
            return new NBTTagString(this.getName(), (String)value);
        }
        if (value instanceof Property) {
            return ((Property)value).convertToNBT();
        }
        System.out.println("Unable to convert a compound property to nbt due to incompatible types.");
        return null;
    }
}

