/*
 * Decompiled with CFR 0.152.
 */
package dnoved1.immersify.entity;

import dnoved1.immersify.PropertyTool;
import dnoved1.immersify.api.IRecipe;
import dnoved1.immersify.api.IRecipeCaller;
import dnoved1.immersify.api.property.Property;
import dnoved1.immersify.api.property.PropertyEmpty;
import dnoved1.immersify.entity.EntityEmpty;
import dnoved1.immersify.graphics.ParticleFireCube;
import dnoved1.immersify.recipe.RecipeManager;
import dnoved1.immersify.util.MathHelper;
import dnoved1.immersify.util.UtilMethods;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityCampfire
extends EntityEmpty {
    public static final float ENTITY_WIDTH = 0.85f;
    public static final float ENTITY_HEIGHT = 0.1f;
    private static final String NBT_POSISTION = "Pos";
    private static final float PARTICLE_DISTANCE = 0.3f;
    private static final int MAX_PARTICLE_COUNTER = 8;
    private static final float PARTICLE_ROTATION_ANGLE = -0.1f;
    private static final int NUMBER_HELICES = 2;
    private int particleCounter = 0;
    private Vec3[] helices;
    private CookProgress cookProgress;

    public EntityCampfire(World world, double x, double y, double z) {
        super(world);
        this.func_70107_b(x, y, z);
    }

    public EntityCampfire(World world) {
        super(world);
    }

    @Override
    protected void func_70088_a() {
        this.func_70105_a(0.85f, 0.1f);
        if (this.field_70170_p.field_72995_K) {
            float partialAngle = (float)Math.PI;
            this.helices = new Vec3[2];
            for (int i = 0; i < 2; ++i) {
                this.helices[i] = Vec3.func_72443_a((double)((MathHelper.cos((float)i * partialAngle) + MathHelper.sin((float)i * partialAngle)) * 0.3f), (double)0.0, (double)((MathHelper.cos((float)i * partialAngle) - MathHelper.sin((float)i * partialAngle)) * 0.3f));
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.cookProgress = new CookProgress();
        }
    }

    @Override
    public void func_70020_e(NBTTagCompound nbtRead) {
        NBTTagList posistion = nbtRead.func_74761_m(NBT_POSISTION);
        this.field_70165_t = ((NBTTagDouble)posistion.func_74743_b((int)0)).field_74755_a;
        this.field_70163_u = ((NBTTagDouble)posistion.func_74743_b((int)1)).field_74755_a;
        this.field_70161_v = ((NBTTagDouble)posistion.func_74743_b((int)2)).field_74755_a;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    @Override
    public void func_70109_d(NBTTagCompound nbtWrite) {
        nbtWrite.func_74782_a(NBT_POSISTION, (NBTBase)this.func_70087_a(new double[]{this.field_70165_t, this.field_70163_u, this.field_70161_v}));
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70097_a(DamageSource damageSource, float amount) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
        return false;
    }

    public boolean func_130002_c(EntityPlayer player) {
        return false;
    }

    @Override
    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            ++this.particleCounter;
            if (this.particleCounter >= 8) {
                this.particleCounter = 0;
                for (Vec3 helix : this.helices) {
                    helix.func_72442_b(-0.1f);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new ParticleFireCube(this.field_70170_p, this.field_70165_t + helix.field_72450_a, this.field_70163_u + helix.field_72448_b + 0.1, this.field_70161_v + helix.field_72449_c, this.field_70165_t, this.field_70163_u, this.field_70161_v));
                }
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.cookProgress.decrementProgress();
        }
    }

    public void func_70100_b_(EntityPlayer player) {
        ItemStack currentItem;
        double distanceSq = this.func_70068_e((Entity)player);
        if (Double.compare(distanceSq, 2.75) < 0) {
            // empty if block
        }
        if (!this.field_70170_p.field_72995_K && (currentItem = player.func_71045_bC()) != null) {
            if (currentItem.func_77984_f()) {
                this.cookProgress.incrementProgress(player.field_70157_k, currentItem.field_77993_c);
            } else {
                this.cookProgress.incrementProgress(player.field_70157_k, currentItem.field_77993_c, currentItem.func_77960_j());
            }
        }
    }

    private class CookProgress {
        private ArrayList<CookProgressEntry> cookingEntries = new ArrayList();

        public void decrementProgress() {
            for (int i = 0; i < this.cookingEntries.size(); ++i) {
                this.cookingEntries.get(i).decrementProgress();
                if (this.cookingEntries.get(i).checkIfValid()) continue;
                this.cookingEntries.remove(i);
            }
        }

        public void incrementProgress(int entityID, int itemID) {
            CookProgressEntry entry = new CookProgressEntry(entityID, itemID);
            this.incrementProgress(entry);
        }

        public void incrementProgress(int entityID, int itemID, int metaData) {
            CookProgressEntry entry = new CookProgressEntry(entityID, itemID, metaData);
            this.incrementProgress(entry);
        }

        private void incrementProgress(CookProgressEntry entry) {
            boolean entryContained = false;
            for (CookProgressEntry cookEntry : this.cookingEntries) {
                if (!cookEntry.equals(entry)) continue;
                cookEntry.incrementProgress();
                entryContained = true;
                cookEntry.checkIfComplete();
            }
            if (!entryContained) {
                this.cookingEntries.add(entry);
                this.incrementProgress(entry);
            }
        }

        private class CookProgressEntry
        implements IRecipeCaller {
            private static final int MIN_COUNTER = -20;
            private static final int MAX_COUNTER = 100;
            private int counter = 0;
            private int entityID;
            private int itemID;
            private int metaData;
            private boolean metaMatters;

            public CookProgressEntry(int entityID, int itemID) {
                this.entityID = entityID;
                this.itemID = itemID;
                this.metaData = 0;
                this.metaMatters = false;
            }

            public CookProgressEntry(int entityID, int itemID, int metaData) {
                this.entityID = entityID;
                this.itemID = itemID;
                this.metaData = metaData;
                this.metaMatters = true;
            }

            public void decrementProgress() {
                --this.counter;
            }

            public void incrementProgress() {
                this.counter += 2;
            }

            public boolean checkIfValid() {
                return this.counter > -20;
            }

            public void checkIfComplete() {
                if (this.counter > 100) {
                    Property[] properties = new Property[]{new PropertyEmpty(Property.PropertyType.HEAT.toString()), new PropertyTool(Property.PropertyType.INGREDIENT.toString(), this.getItemStack())};
                    IRecipe recipe = RecipeManager.getFirstMatchingRecipe(properties);
                    if (recipe != null) {
                        recipe.onCrafted(this);
                    }
                }
            }

            public ItemStack getItemStack() {
                ItemStack is = new ItemStack(this.itemID, 1, 0);
                if (this.metaMatters) {
                    is.func_77964_b(this.metaData);
                }
                return is;
            }

            public boolean equals(Object o) {
                if (o == null) {
                    return false;
                }
                if (!(o instanceof CookProgressEntry)) {
                    return false;
                }
                CookProgressEntry otherEntry = (CookProgressEntry)o;
                if (this.entityID != otherEntry.entityID) {
                    return false;
                }
                if (this.itemID != otherEntry.itemID) {
                    return false;
                }
                return !this.metaMatters || this.metaData == otherEntry.metaData;
            }

            @Override
            public void recieveData(Property ... data) {
                for (Property datum : data) {
                    Object containedObject = datum.reconstructObject();
                    if (!datum.getName().equals(Property.PropertyCommand.ADD.toString()) || !(containedObject instanceof ItemStack)) continue;
                    EntityPlayer player = UtilMethods.getPlayerFromID(EntityCampfire.this.field_70170_p, this.entityID);
                    ItemStack result = (ItemStack)containedObject;
                    if (player != null) {
                        ItemStack currentItem = player.func_71045_bC();
                        --currentItem.field_77994_a;
                        if (currentItem.field_77994_a <= 0) {
                            player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                        }
                        if (!player.field_71071_by.func_70441_a(result)) {
                            EntityItem entityItem = new EntityItem(EntityCampfire.this.field_70170_p, EntityCampfire.this.field_70165_t, EntityCampfire.this.field_70163_u, EntityCampfire.this.field_70161_v, result);
                            EntityCampfire.this.field_70170_p.func_72838_d((Entity)entityItem);
                        }
                    }
                    this.counter = 0;
                }
            }
        }
    }
}

