/*
 * Decompiled with CFR 0.152.
 */
package dnoved1.immersify.graphics.gui;

import dnoved1.immersify.Redux;
import dnoved1.immersify.api.CustomPacket;
import dnoved1.immersify.graphics.NormalIcon;
import dnoved1.immersify.graphics.gui.GuiTrace;
import dnoved1.immersify.graphics.gui.SelfOrientingGui;
import dnoved1.immersify.util.UtilMethods;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class GuiChest
extends SelfOrientingGui {
    private static final ResourceLocation WIDGETS_TEXTURE = new ResourceLocation("textures/gui/widgets.png");
    private static final Icon HOTBAR_ICON = new NormalIcon(256, 256, 1, 1, 60, 20);
    private static final Icon SELECTOR_ICON = new NormalIcon(256, 256, 1, 23, 21, 21);
    private static final ResourceLocation ASCII_TEXTURE = new ResourceLocation("textures/font/ascii.png");
    private static final Icon LEFT_ARROW_ICON = new NormalIcon(128, 128, 0, 8, 8, 8);
    private static final Icon RIGHT_ARROW_ICON = new NormalIcon(128, 128, 8, 8, 8, 8);
    private static final byte BUTTON_LEFT_SLOT = 0;
    private static final byte BUTTON_MIDDLE_SLOT = 1;
    private static final byte BUTTON_RIGHT_SLOT = 2;
    private static long leftClickCounter = 0L;
    private static final float width = 3.0f;
    private static final float height = 1.0f;
    private int chestX;
    private int chestY;
    private int chestZ;
    private ItemStack[] currentContents = new ItemStack[27];
    private int itemOffset;

    public GuiChest(int chestX, int chestY, int chestZ) {
        this((double)chestX + 0.5, (double)chestY + 1.5, (double)chestZ + 0.5, chestX, chestY, chestZ);
    }

    public GuiChest(double centerX, double centerY, double centerZ, int chestX, int chestY, int chestZ) {
        super(true, true, centerX, centerY, centerZ);
        this.chestX = chestX;
        this.chestY = chestY;
        this.chestZ = chestZ;
        this.clientRequestInventory(chestX, chestY, chestZ);
    }

    @Override
    public void render(float partialTick) {
        for (int i = -1; i < 2; ++i) {
            this.renderTextureInWorld(WIDGETS_TEXTURE, SELECTOR_ICON, true, 1.0f, 1.0f, i, 0.0f);
            int item = (this.itemOffset + i + 27) % 27;
            if (this.currentContents[item] == null) continue;
            this.renderItemInWorld(this.currentContents[item], 0.6f, (int)Minecraft.func_71410_x().field_71441_e.func_72820_D(), partialTick, i, 0.0f);
            int stringOffset = this.currentContents[item].field_77994_a < 10 ? 5 : (this.currentContents[item].field_77994_a < 100 ? 0 : -5);
            this.renderStringInWorld("" + this.currentContents[item].field_77994_a, 255, (i == -1 ? -35 : (i == 0 ? 5 : (i == 1 ? 44 : 0))) + stringOffset, 8, this.currentContents[item].func_77973_b() instanceof ItemBlock && RenderBlocks.func_78597_b((int)Block.field_71973_m[this.currentContents[item].field_77993_c].func_71857_b()) ? 0.4f : 0.01f, 0.025f);
        }
    }

    @Override
    public boolean consumeClick(GuiTrace guiTrace) {
        if (!GuiChest.enoughTimePassedSinceClick()) {
            return false;
        }
        guiTrace = this.rotateTraceOffsets(guiTrace);
        if (guiTrace.xOffset < -0.5) {
            this.clientSendButtonClick((byte)0);
            leftClickCounter = Minecraft.func_71386_F();
            return true;
        }
        if (guiTrace.xOffset > 0.5) {
            this.clientSendButtonClick((byte)2);
            leftClickCounter = Minecraft.func_71386_F();
            return true;
        }
        this.clientSendButtonClick((byte)1);
        leftClickCounter = Minecraft.func_71386_F();
        return true;
    }

    public boolean consumeScroll(int scroll) {
        if (scroll == 1) {
            this.itemOffset = (this.itemOffset + 1) % 27;
            return true;
        }
        if (scroll == -1) {
            this.itemOffset = (this.itemOffset + 26) % 27;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTraceWithinBounds(GuiTrace guiTrace) {
        GuiTrace newGuiTrace = this.rotateTraceOffsets(guiTrace);
        return Math.abs(newGuiTrace.xOffset) < 1.5 && Math.abs(newGuiTrace.yOffset) < 0.5;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof GuiChest)) {
            return false;
        }
        GuiChest otherGui = (GuiChest)o;
        return this.equals(otherGui.chestX, otherGui.chestY, otherGui.chestZ);
    }

    public boolean equals(int chestX, int chestY, int chestZ) {
        return this.chestX == chestX && this.chestY == chestY && this.chestZ == chestZ;
    }

    public static GuiChest getGuiForCoordinates(int chestX, int chestY, int chestZ) {
        Object gui;
        int i;
        for (i = 0; i < Redux.INSTANCE.renderableGuis.size(); ++i) {
            gui = Redux.INSTANCE.renderableGuis.get(i);
            if (!(gui instanceof GuiChest) || !((GuiChest)gui).equals(chestX, chestY, chestZ)) continue;
            return (GuiChest)gui;
        }
        for (i = 0; i < Redux.INSTANCE.clickableGuis.size(); ++i) {
            gui = Redux.INSTANCE.clickableGuis.get(i);
            if (!(gui instanceof GuiChest) || !((GuiChest)gui).equals(chestX, chestY, chestZ)) continue;
            return (GuiChest)gui;
        }
        return null;
    }

    public static boolean consumeRightClick(PlayerInteractEvent pie) {
        TileEntity te = pie.entityPlayer.field_70170_p.func_72796_p(pie.x, pie.y, pie.z);
        if (te != null && te instanceof TileEntityChest) {
            Object gui;
            int i;
            TileEntityChest teChest = (TileEntityChest)te;
            if (teChest.field_70427_h <= 0) {
                GuiChest newGui = new GuiChest(pie.x, pie.y, pie.z);
                Redux.INSTANCE.renderableGuis.add(newGui);
                Redux.INSTANCE.clickableGuis.add(newGui);
                teChest.func_70295_k_();
                return true;
            }
            for (i = 0; i < Redux.INSTANCE.renderableGuis.size(); ++i) {
                gui = Redux.INSTANCE.renderableGuis.get(i);
                if (!(gui instanceof GuiChest) || !((GuiChest)gui).equals(pie.x, pie.y, pie.z)) continue;
                Redux.INSTANCE.renderableGuis.remove(i);
            }
            for (i = 0; i < Redux.INSTANCE.clickableGuis.size(); ++i) {
                gui = Redux.INSTANCE.clickableGuis.get(i);
                if (!(gui instanceof GuiChest) || !((GuiChest)gui).equals(pie.x, pie.y, pie.z)) continue;
                Redux.INSTANCE.clickableGuis.remove(i);
            }
            teChest.func_70305_f();
            return true;
        }
        return false;
    }

    private static boolean enoughTimePassedSinceClick() {
        return Minecraft.func_71386_F() - leftClickCounter > 100L;
    }

    private void clientRequestInventory(int x, int y, int z) {
        try {
            ByteArrayOutputStream packetData = new ByteArrayOutputStream();
            DataOutputStream packetWrite = new DataOutputStream(packetData);
            packetWrite.writeInt(x);
            packetWrite.writeByte(y);
            packetWrite.writeInt(z);
            packetWrite.writeInt(Minecraft.func_71410_x().field_71439_g.field_70157_k);
            CustomPacket packet = new CustomPacket("Request Chest Inventory", packetData.toByteArray());
            Minecraft.func_71410_x().func_71391_r().func_72552_c((Packet)packet);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void clientSendButtonClick(byte button) {
        try {
            ByteArrayOutputStream packetData = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(packetData);
            data.writeInt(this.chestX);
            data.writeByte(this.chestY);
            data.writeInt(this.chestZ);
            data.writeInt(Minecraft.func_71410_x().field_71439_g.field_70157_k);
            data.writeByte(button);
            data.writeByte(this.itemOffset);
            CustomPacket packet = new CustomPacket("Send Button Click", packetData.toByteArray());
            Minecraft.func_71410_x().func_71391_r().func_72552_c((Packet)packet);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void clientHandleContentPacket(CustomPacket packet) {
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(packet.getData()));
        try {
            int x = data.readInt();
            byte y = data.readByte();
            int z = data.readInt();
            GuiChest gui = GuiChest.getGuiForCoordinates(x, y, z);
            if (gui != null) {
                while (data.available() > 0) {
                    ItemStack is;
                    byte slot = data.readByte();
                    gui.currentContents[slot] = is = Packet.func_73276_c((DataInput)data);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void serverSendChestInventory(int playerID, int x, int y, int z) {
        WorldServer world;
        EntityPlayerMP player = null;
        WorldServer[] arr$ = MinecraftServer.func_71276_C().field_71305_c;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (player = (EntityPlayerMP)UtilMethods.getPlayerFromID((World)(world = arr$[i$]), playerID)) == null; ++i$) {
        }
        if (player == null) {
            System.out.println("Could not find player to send chest data to");
            return;
        }
        TileEntity te = player.field_70170_p.func_72796_p(x, y, z);
        if (te != null && te instanceof TileEntityChest) {
            TileEntityChest teChest = (TileEntityChest)te;
            try {
                ByteArrayOutputStream packetData = new ByteArrayOutputStream();
                DataOutputStream packetWrite = new DataOutputStream(packetData);
                packetWrite.writeInt(x);
                packetWrite.writeByte(y);
                packetWrite.writeInt(z);
                for (int i = 0; i < teChest.func_70302_i_(); ++i) {
                    packetWrite.writeByte(i);
                    Packet.func_73270_a((ItemStack)teChest.func_70301_a(i), (DataOutput)packetWrite);
                }
                CustomPacket packet = new CustomPacket("Send Chest Inventory", packetData.toByteArray());
                player.field_71135_a.func_72567_b((Packet)packet);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void serverRecieveButtonClick(int x, int y, int z, int playerID, byte button, byte slot) {
        WorldServer world;
        switch (button) {
            case 0: {
                slot = (byte)(slot - 1);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                slot = (byte)(slot + 1);
                break;
            }
            default: {
                return;
            }
        }
        slot = (byte)((slot + 27) % 27);
        EntityPlayer player = null;
        WorldServer[] arr$ = MinecraftServer.func_71276_C().field_71305_c;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (player = UtilMethods.getPlayerFromID((World)(world = arr$[i$]), playerID)) == null; ++i$) {
        }
        if (player == null) {
            System.out.println("Could not find player for button click");
            return;
        }
        TileEntity te = player.field_70170_p.func_72796_p(x, y, z);
        if (te != null && te instanceof TileEntityChest) {
            TileEntityChest teChest = (TileEntityChest)te;
            ItemStack is = teChest.func_70301_a((int)slot);
            ItemStack heldItem = player.func_71045_bC();
            if (player.func_70093_af()) {
                if (heldItem == null) {
                    return;
                }
                if (is == null) {
                    teChest.func_70299_a((int)slot, new ItemStack(heldItem.field_77993_c, 1, heldItem.func_77960_j()));
                    --heldItem.field_77994_a;
                    if (heldItem.field_77994_a <= 0) {
                        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                    }
                } else if (is.func_77969_a(heldItem)) {
                    ++is.field_77994_a;
                    --heldItem.field_77994_a;
                    if (heldItem.field_77994_a <= 0) {
                        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                    }
                }
            } else {
                if (is == null) {
                    return;
                }
                if (heldItem == null) {
                    player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = new ItemStack(is.field_77993_c, 1, is.func_77960_j());
                    --is.field_77994_a;
                    if (is.field_77994_a <= 0) {
                        teChest.func_70299_a((int)slot, null);
                    }
                } else if (is.func_77969_a(player.func_71045_bC())) {
                    ++heldItem.field_77994_a;
                    --is.field_77994_a;
                    if (is.field_77994_a <= 0) {
                        teChest.func_70299_a((int)slot, null);
                    }
                } else {
                    teChest.field_70331_k.func_72838_d((Entity)new EntityItem(teChest.field_70331_k, (double)teChest.field_70329_l + 0.5, (double)teChest.field_70330_m + 1.5, (double)teChest.field_70327_n + 0.5, new ItemStack(is.field_77993_c, 1, is.func_77960_j())));
                    --is.field_77994_a;
                    if (is.field_77994_a <= 0) {
                        teChest.func_70299_a((int)slot, null);
                    }
                }
            }
            GuiChest.serverSendChestInventory(playerID, x, y, z);
        }
    }
}

