/*
 * Decompiled with CFR 0.152.
 */
package dnoved1.immersify.graphics;

import dnoved1.immersify.util.EnumRenderType;
import dnoved1.immersify.util.MathHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GraphicsHelper {
    private static RenderBlocks blockRenderer = new RenderBlocks();
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static Random random = new Random();

    public static void renderTextureInWorld(ResourceLocation textureLocation, Icon texture, boolean transparency, double x, double y, double z, double horizontalRotation, double verticalRotation, float width, float height) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glPushMatrix();
        if (transparency) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
        }
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslated((double)(x -= RenderManager.field_78725_b), (double)(y -= RenderManager.field_78726_c), (double)(z -= RenderManager.field_78723_d));
        GL11.glRotated((double)MathHelper.convertR2D(horizontalRotation), (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)MathHelper.convertR2D(verticalRotation), (double)1.0, (double)0.0, (double)0.0);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(textureLocation);
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(-width / 2.0f), (double)(-height / 2.0f), 0.0, (double)texture.func_94209_e(), (double)texture.func_94206_g());
        tessellator.func_78374_a((double)(width / 2.0f), (double)(-height / 2.0f), 0.0, (double)texture.func_94212_f(), (double)texture.func_94206_g());
        tessellator.func_78374_a((double)(width / 2.0f), (double)(height / 2.0f), 0.0, (double)texture.func_94212_f(), (double)texture.func_94210_h());
        tessellator.func_78374_a((double)(-width / 2.0f), (double)(height / 2.0f), 0.0, (double)texture.func_94209_e(), (double)texture.func_94210_h());
        tessellator.func_78381_a();
        GL11.glDisable((int)32826);
        if (transparency) {
            GL11.glDisable((int)3042);
        }
        GL11.glPopMatrix();
    }

    public static void renderStringInWorld(String string, int color, double x, double y, double z, float size, double horizontalRotation, double verticalRotation, int xOffset, int yOffset, float zOffset) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslated((double)(x -= RenderManager.field_78725_b), (double)(y -= RenderManager.field_78726_c), (double)(z -= RenderManager.field_78723_d));
        GL11.glRotated((double)MathHelper.convertR2D(horizontalRotation), (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)MathHelper.convertR2D(verticalRotation), (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-zOffset));
        GL11.glScalef((float)size, (float)size, (float)size);
        Minecraft.func_71410_x().field_71466_p.func_78276_b(string, xOffset, yOffset, color);
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    public static void renderItemInWorld(ItemStack is, float size, int age, double x, double y, double z, float partialTick, double horizontalRotation, double verticalRotation) {
        if (is == null || is.func_77973_b() == null) {
            return;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        RenderManager.field_78727_a.field_78724_e.func_110577_a(RenderManager.field_78727_a.field_78724_e.func_130087_a(is.func_94608_d()));
        random.setSeed(187L);
        boolean shouldBob = false;
        boolean renderWithColor = true;
        GL11.glPushMatrix();
        float bobOffset = shouldBob ? MathHelper.sin(((float)age + partialTick) / 10.0f) * 0.1f + 0.1f : 0.0f;
        float rotation = MathHelper.convertR2D(((float)age + partialTick) / 20.0f);
        GL11.glTranslated((double)(x -= RenderManager.field_78725_b), (double)((y -= RenderManager.field_78726_c) + (double)bobOffset), (double)(z -= RenderManager.field_78723_d));
        GL11.glEnable((int)32826);
        GL11.glScalef((float)size, (float)size, (float)size);
        GL11.glRotatef((float)((float)MathHelper.convertR2D(horizontalRotation) + rotation), (float)0.0f, (float)1.0f, (float)0.0f);
        Block block = null;
        if (is.field_77993_c < Block.field_71973_m.length) {
            block = Block.field_71973_m[is.field_77993_c];
        }
        if (is.func_94608_d() == 0 && block != null && RenderBlocks.func_78597_b((int)Block.field_71973_m[is.field_77993_c].func_71857_b())) {
            float scale = 1.0f;
            int renderType = block.func_71857_b();
            if (renderType == EnumRenderType.CROSSED_SQUARES.getRenderCode() || renderType == EnumRenderType.PLANT_STEM.getRenderCode() || renderType == EnumRenderType.LEVER.getRenderCode() || renderType == EnumRenderType.TORCH.getRenderCode()) {
                scale *= 2.0f;
            }
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glPushMatrix();
            blockRenderer.func_78600_a(block, is.func_77960_j(), 1.0f);
            GL11.glPopMatrix();
        } else {
            boolean rmrp = is.func_77973_b().func_77623_v();
            for (int renderPass = 0; renderPass < (rmrp ? is.func_77973_b().getRenderPasses(is.func_77960_j()) : 1); ++renderPass) {
                float colorBlue;
                float colorGreen;
                float colorRed;
                random.setSeed(187L);
                Icon icon = is.func_77973_b().getIcon(is, renderPass);
                if (renderWithColor) {
                    int colorInt = Item.field_77698_e[is.field_77993_c].func_82790_a(is, renderPass);
                    colorRed = (float)(colorInt >> 16 & 0xFF) / 255.0f;
                    colorGreen = (float)(colorInt >> 8 & 0xFF) / 255.0f;
                    colorBlue = (float)(colorInt & 0xFF) / 255.0f;
                    GL11.glColor4f((float)colorRed, (float)colorGreen, (float)colorBlue, (float)1.0f);
                } else {
                    colorRed = 1.0f;
                    colorGreen = 1.0f;
                    colorBlue = 1.0f;
                }
                if (icon == null) {
                    TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
                    ResourceLocation resourcelocation = texturemanager.func_130087_a(is.func_94608_d());
                    icon = ((TextureMap)texturemanager.func_110581_b(resourcelocation)).func_110572_b("missingno");
                }
                if (RenderManager.field_78727_a.field_78733_k.field_74347_j) {
                    float float1 = 0.0625f;
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.001f);
                    if (is.func_94608_d() == 0) {
                        RenderManager.field_78727_a.field_78724_e.func_110577_a(TextureMap.field_110575_b);
                    } else {
                        RenderManager.field_78727_a.field_78724_e.func_110577_a(TextureMap.field_110576_c);
                    }
                    GL11.glColor4f((float)colorRed, (float)colorGreen, (float)colorBlue, (float)1.0f);
                    ItemRenderer.func_78439_a((Tessellator)tessellator, (float)icon.func_94212_f(), (float)icon.func_94206_g(), (float)icon.func_94209_e(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)float1);
                    if (is.hasEffect(renderPass)) {
                        GL11.glDepthFunc((int)514);
                        GL11.glDisable((int)2896);
                        RenderManager.field_78727_a.field_78724_e.func_110577_a(RES_ITEM_GLINT);
                        GL11.glEnable((int)3042);
                        GL11.glBlendFunc((int)768, (int)1);
                        float effectColorMultiplier = 0.76f;
                        GL11.glColor4f((float)(0.5f * effectColorMultiplier), (float)(0.25f * effectColorMultiplier), (float)(0.8f * effectColorMultiplier), (float)1.0f);
                        GL11.glMatrixMode((int)5890);
                        GL11.glPushMatrix();
                        float effectScaleFactor = 0.125f;
                        GL11.glScalef((float)effectScaleFactor, (float)effectScaleFactor, (float)effectScaleFactor);
                        float effectXOffset = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
                        GL11.glTranslatef((float)effectXOffset, (float)0.0f, (float)0.0f);
                        GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)255, (int)255, (float)float1);
                        GL11.glPopMatrix();
                        GL11.glPushMatrix();
                        GL11.glScalef((float)effectScaleFactor, (float)effectScaleFactor, (float)effectScaleFactor);
                        effectXOffset = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
                        GL11.glTranslatef((float)(-effectXOffset), (float)0.0f, (float)0.0f);
                        GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)255, (int)255, (float)float1);
                        GL11.glPopMatrix();
                        GL11.glMatrixMode((int)5888);
                        GL11.glDisable((int)3042);
                        GL11.glEnable((int)2896);
                        GL11.glDepthFunc((int)515);
                    }
                    GL11.glPopMatrix();
                    continue;
                }
                GL11.glColor4f((float)colorRed, (float)colorGreen, (float)colorBlue, (float)1.0f);
                tessellator.func_78382_b();
                tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
                tessellator.func_78374_a(-0.5, -0.5, (double)0.001f, (double)icon.func_94209_e(), (double)icon.func_94210_h());
                tessellator.func_78374_a(0.5, -0.5, (double)0.001f, (double)icon.func_94212_f(), (double)icon.func_94210_h());
                tessellator.func_78374_a(0.5, 0.5, (double)0.001f, (double)icon.func_94212_f(), (double)icon.func_94206_g());
                tessellator.func_78374_a(-0.5, 0.5, (double)0.001f, (double)icon.func_94209_e(), (double)icon.func_94206_g());
                tessellator.func_78381_a();
            }
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }
}

