/*
 * Decompiled with CFR 0.152.
 */
package dnoved1.immersify.asm;

import java.util.ArrayList;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

public class ReduxClassWriter
extends ClassWriter {
    static SuperClassMap superClassMap = new SuperClassMap();
    static String OCLASS_MODEL_CHEST = "bbd";
    static String OCLASS_MODEL_BASE = "bbo";
    static String DCLASS_MODEL_BASE = "net/minecraft/client/model/ModelBase";

    public ReduxClassWriter(int flags) {
        super(flags);
    }

    public ReduxClassWriter(ClassReader classReader, int flags) {
        super(classReader, flags);
    }

    protected String getCommonSuperClass(String type1, String type2) {
        String[] type1Supers = superClassMap.getSuperClasses(type1);
        String[] type2Supers = superClassMap.getSuperClasses(type2);
        int bestMatchNum = Integer.MAX_VALUE;
        String bestMatch = null;
        for (int i = 0; i < type1Supers.length; ++i) {
            for (int j = 0; j < type2Supers.length; ++j) {
                int thisMatchNum;
                if (!type1Supers[i].equals(type2Supers[j]) || (thisMatchNum = i + j) >= bestMatchNum) continue;
                bestMatchNum = thisMatchNum;
                bestMatch = type1Supers[i];
            }
        }
        if (bestMatch != null) {
            return bestMatch;
        }
        System.out.println("Redux Class Loader could not find the common superclass of " + type1 + " and " + type2 + ".");
        return "java/lang/Object";
    }

    static {
        superClassMap.addSuperClassMapping(OCLASS_MODEL_CHEST, OCLASS_MODEL_BASE, DCLASS_MODEL_BASE);
    }

    private static class SuperClassMap {
        private ArrayList<MultipleMap<String, String>> superClassesMap = new ArrayList();

        private SuperClassMap() {
        }

        public void addSuperClassMapping(String className, String ... superClasses) {
            this.superClassesMap.add(new MultipleMap<String, String>(className, superClasses));
        }

        public String[] getSuperClasses(String className) {
            ArrayList<String> superClasses = new ArrayList<String>();
            for (MultipleMap<String, String> mapping : this.superClassesMap) {
                String[] mapValues;
                if (!mapping.keysMatch(className)) continue;
                for (String value : mapValues = mapping.getValues()) {
                    superClasses.add(value);
                }
            }
            return superClasses.toArray(new String[0]);
        }

        private class MultipleMap<K, V> {
            private K key;
            private V[] values;

            public MultipleMap(K key, V ... values) {
                this.key = key;
                this.values = values;
            }

            public boolean keysMatch(K otherKey) {
                return this.key.equals(otherKey);
            }

            public V[] getValues() {
                return this.values;
            }
        }
    }
}

