/*
 * Decompiled with CFR 0.152.
 */
package dnoved1.immersify.api.property;

import dnoved1.immersify.api.property.Property;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;

public class PropertyNumber<T extends Number>
extends Property<T> {
    public PropertyNumber(String name, T value) {
        super(name, value);
    }

    public PropertyNumber(String name, T value, int comparable) {
        super(name, value, comparable);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        return ((Number)this.getValue()).equals(((Property)o).getValue());
    }

    @Override
    public int compareTo(Property<T> p) {
        if (p == null) {
            throw new NullPointerException();
        }
        Number myValue = (Number)this.getValue();
        Number otherValue = (Number)p.getValue();
        if (myValue.getClass() != otherValue.getClass()) {
            return -2;
        }
        if (myValue instanceof Comparable) {
            int compareCode = ((Comparable)((Object)myValue)).compareTo(otherValue);
            return compareCode < 0 ? -1 : (compareCode > 0 ? 1 : compareCode);
        }
        return -2;
    }

    @Override
    public NBTBase convertToNBT() {
        Number myValue = (Number)this.getValue();
        if (myValue instanceof Byte) {
            return new NBTTagByte(this.getName(), ((Byte)myValue).byteValue());
        }
        if (myValue instanceof Short) {
            return new NBTTagShort(this.getName(), ((Short)myValue).shortValue());
        }
        if (myValue instanceof Integer) {
            return new NBTTagInt(this.getName(), ((Integer)myValue).intValue());
        }
        if (myValue instanceof Long) {
            return new NBTTagLong(this.getName(), ((Long)myValue).longValue());
        }
        if (myValue instanceof Float) {
            return new NBTTagFloat(this.getName(), ((Float)myValue).floatValue());
        }
        if (myValue instanceof Double) {
            return new NBTTagDouble(this.getName(), ((Float)myValue).doubleValue());
        }
        return null;
    }
}

