/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.natura.common.NContent;
import mods.natura.common.PHNatura;
import mods.natura.entity.BabyHeatscarSpider;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class HeatscarSpider
extends EntitySpider {
    public HeatscarSpider(World par1World) {
        super(par1World);
        this.setSize(2.7f, 1.9f);
        this.isImmuneToFire = true;
        this.experienceValue = 25;
    }

    @SideOnly(value=Side.CLIENT)
    public float spiderScaleAmount() {
        return 2.0f;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(50.0);
        this.getEntityAttribute(SharedMonsterAttributes.followRange).setBaseValue(24.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(1.35);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(4.0);
    }

    protected void attackEntity(Entity par1Entity, float par2) {
        if (par2 > 2.0f && par2 < 6.0f && this.rand.nextInt(10) == 0) {
            if (this.onGround) {
                double d0 = par1Entity.posX - this.posX;
                double d1 = par1Entity.posZ - this.posZ;
                float f2 = MathHelper.sqrt_double((double)(d0 * d0 + d1 * d1));
                this.motionX = d0 / (double)f2 * 0.5 + this.motionX * (double)0.2f;
                this.motionZ = d1 / (double)f2 * 0.5 + this.motionZ * (double)0.2f;
                this.motionY = 0.62;
            }
        } else {
            super.attackEntity(par1Entity, par2);
        }
    }

    public void jump() {
        this.motionY = 0.62;
        if (this.isPotionActive(Potion.jump)) {
            this.motionY += (double)((float)(this.getActivePotionEffect(Potion.jump).getAmplifier() + 1) * 0.1f);
        }
        if (this.isSprinting()) {
            float f = this.rotationYaw * ((float)Math.PI / 180);
            this.motionX -= (double)(MathHelper.sin((float)f) * 0.2f);
            this.motionZ += (double)(MathHelper.cos((float)f) * 0.2f);
        }
        this.isAirBorne = true;
        ForgeHooks.onLivingJump((EntityLivingBase)this);
    }

    protected void fall(float par1) {
        if ((par1 = ForgeHooks.onLivingFall((EntityLivingBase)this, (float)par1)) <= 0.0f) {
            return;
        }
        super.fall(par1);
        int i = MathHelper.ceiling_float_int((float)(par1 - 5.0f));
        if (i > 0) {
            if (i > 4) {
                this.playSound("damage.fallbig", 1.0f, 1.0f);
            } else {
                this.playSound("damage.fallsmall", 1.0f, 1.0f);
            }
            this.attackEntityFrom(DamageSource.fall, i);
            Block j = this.worldObj.getBlock(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)(this.posY - (double)0.2f - (double)this.yOffset)), MathHelper.floor_double((double)this.posZ));
            if (j != null) {
                Block.SoundType stepsound = j.stepSound;
                this.playSound(stepsound.func_150496_b(), stepsound.getVolume() * 0.5f, stepsound.getPitch() * 0.75f);
            }
        }
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        if (super.attackEntityAsMob(par1Entity)) {
            if (par1Entity instanceof EntityLiving) {
                int b0 = 0;
                if (this.worldObj.difficultySetting != EnumDifficulty.PEACEFUL) {
                    if (this.worldObj.difficultySetting == EnumDifficulty.NORMAL) {
                        b0 = 5;
                    } else if (this.worldObj.difficultySetting == EnumDifficulty.HARD) {
                        b0 = 10;
                    }
                }
                if (b0 > 0) {
                    par1Entity.setFire(b0);
                }
            }
            return true;
        }
        return false;
    }

    public int getAttackStrength(Entity par1Entity) {
        return 4;
    }

    protected Item getDropItem() {
        return NContent.plantItem;
    }

    public EntityItem func_145778_a(Item par1, int par2, float par3) {
        return this.entityDropItem(new ItemStack(par1, par2, 7), par3);
    }

    protected void dropFewItems(boolean par1, int par2) {
        Item j = this.getDropItem();
        if (j != null) {
            int k = this.rand.nextInt(3) + 2;
            if (par2 > 0) {
                k += this.rand.nextInt(par2 + 1);
            }
            for (int l = 0; l < k; ++l) {
                this.dropItem(j, 1);
            }
        }
    }

    public boolean getCanSpawnHere() {
        return this.worldObj.difficultySetting != EnumDifficulty.PEACEFUL && this.worldObj.checkNoEntityCollision(this.boundingBox) && this.worldObj.getCollidingBoundingBoxes((Entity)this, this.boundingBox).isEmpty() && !this.worldObj.isAnyLiquid(this.boundingBox);
    }

    protected BabyHeatscarSpider createBabyInstance() {
        return new BabyHeatscarSpider(this.worldObj);
    }

    public void setDead() {
        if (!this.worldObj.isRemote) {
            int num = PHNatura.babyHeatscarMaximum - PHNatura.babyHeatscarMinimum + 1;
            int amount = this.rand.nextInt(num) + PHNatura.babyHeatscarMinimum;
            for (int i = 0; i < amount; ++i) {
                double f = this.rand.nextDouble() * 2.0;
                double f1 = this.rand.nextDouble() * 2.0;
                BabyHeatscarSpider babyspider = this.createBabyInstance();
                babyspider.setLocationAndAngles(this.posX + f, this.posY + 0.5, this.posZ + f1, this.rand.nextFloat() * 360.0f, 0.0f);
                this.worldObj.spawnEntityInWorld((Entity)babyspider);
            }
        }
        super.setDead();
    }
}

