/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.plugins.minefactoryreloaded.harvestables;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.api.IFactoryHarvestable;

public class HarvestableNaturaCropPlant
implements IFactoryHarvestable {
    private Block _sourceId;
    private Item _cottonItemId;

    public HarvestableNaturaCropPlant(Block sourceId, Item cottonItemId) {
        this._sourceId = sourceId;
        this._cottonItemId = cottonItemId;
    }

    public Block getPlant() {
        return this._sourceId;
    }

    public HarvestType getHarvestType() {
        return HarvestType.Normal;
    }

    public boolean breakBlock() {
        return false;
    }

    public boolean canBeHarvested(World world, Map<String, Boolean> harvesterSettings, int x, int y, int z) {
        return world.getBlockMetadata(x, y, z) == 3 || world.getBlockMetadata(x, y, z) == 8;
    }

    public List<ItemStack> getDrops(World world, Random rand, Map<String, Boolean> harvesterSettings, int x, int y, int z) {
        if (world.getBlockMetadata(x, y, z) == 8) {
            ItemStack[] returnItems = new ItemStack[]{new ItemStack(this._cottonItemId, 1, 3)};
            return Arrays.asList(returnItems);
        }
        return this._sourceId.getDrops(world, x, y, z, world.getBlockMetadata(x, y, z), 0);
    }

    public void preHarvest(World world, int x, int y, int z) {
    }

    public void postHarvest(World world, int x, int y, int z) {
        if (world.getBlockMetadata(x, y, z) == 3) {
            world.setBlockToAir(x, y, z);
        } else if (world.getBlockMetadata(x, y, z) == 8) {
            world.setBlockMetadataWithNotify(x, y, z, 6, 2);
        }
    }
}

