/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.blocks.trees;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mods.natura.common.NaturaTab;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class DarkTreeBlock
extends Block {
    public IIcon[] icons;
    public String[] textureNames = new String[]{"darkwood_bark", "darkwood_heart", "fusewood_bark", "fusewood_heart"};

    public DarkTreeBlock() {
        super(Material.wood);
        this.setHardness(3.5f);
        this.setResistance(40.0f);
        this.setStepSound(Block.soundTypeWood);
        this.setCreativeTab((CreativeTabs)NaturaTab.tab);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int metadata) {
        int tex = metadata % 4 * 2;
        int orientation = metadata / 4;
        switch (orientation) {
            case 0: {
                if (side != 0 && side != 1) break;
                return this.icons[tex + 1];
            }
            case 1: {
                if (side != 4 && side != 5) break;
                return this.icons[tex + 1];
            }
            case 2: {
                if (side != 2 && side != 3) break;
                return this.icons[tex + 1];
            }
        }
        return this.icons[tex];
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.icons = new IIcon[this.textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.registerIcon("natura:" + this.textureNames[i]);
        }
    }

    public Item getItemDropped(int par1, Random par2Random, int par3) {
        return Item.getItemFromBlock((Block)this);
    }

    public void breakBlock(World par1World, int par2, int par3, int par4, int par5, int par6) {
        int b0 = 4;
        int j1 = b0 + 1;
        if (par1World.checkChunksExist(par2 - j1, par3 - j1, par4 - j1, par2 + j1, par3 + j1, par4 + j1)) {
            for (int k1 = -b0; k1 <= b0; ++k1) {
                for (int l1 = -b0; l1 <= b0; ++l1) {
                    for (int i2 = -b0; i2 <= b0; ++i2) {
                        Block j2 = par1World.getBlock(par2 + k1, par3 + l1, par4 + i2);
                        if (j2 == null) continue;
                        j2.beginLeavesDecay(par1World, par2 + k1, par3 + l1, par4 + i2);
                    }
                }
            }
        }
    }

    public int onBlockPlaced(World par1World, int par2, int par3, int par4, int par5, float par6, float par7, float par8, int par9) {
        int j1 = par9 & 3;
        int b0 = 0;
        switch (par5) {
            case 0: 
            case 1: {
                b0 = 0;
                break;
            }
            case 2: 
            case 3: {
                b0 = 8;
                break;
            }
            case 4: 
            case 5: {
                b0 = 4;
            }
        }
        return j1 | b0;
    }

    public int damageDropped(int par1) {
        return par1 & 3;
    }

    public static int limitToValidMetadata(int par0) {
        return par0 & 3;
    }

    protected ItemStack createStackedBlock(int par1) {
        return new ItemStack((Block)this, 1, DarkTreeBlock.limitToValidMetadata(par1));
    }

    public boolean isBlockReplaceable(World world, int x, int y, int z) {
        return false;
    }

    public void onBlockHarvested(World world, int x, int y, int z, int meta, EntityPlayer player) {
        if (meta % 4 == 1) {
            if (world.difficultySetting.getDifficultyId() > 2) {
                world.createExplosion(null, (double)x, (double)y, (double)z, 1.75f, false);
            } else {
                world.createExplosion(null, (double)x, (double)y, (double)z, 2.0f, false);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < this.icons.length / 2; ++i) {
            par3List.add(new ItemStack(par1, 1, i));
        }
    }

    public boolean canSustainLeaves(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public boolean isWood(IBlockAccess world, int x, int y, int z) {
        return true;
    }
}

