/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.blocks.trees;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mods.natura.client.SaguaroRenderer;
import mods.natura.common.NContent;
import mods.natura.common.NaturaTab;
import mods.natura.worldgen.SaguaroGen;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class SaguaroBlock
extends Block
implements IPlantable {
    public IIcon[] icons;
    public String[] textureNames = new String[]{"saguaro_bottom", "saguaro_top", "saguaro_side", "saguaro_fruit"};

    public SaguaroBlock() {
        super(Material.cactus);
        this.setCreativeTab((CreativeTabs)NaturaTab.tab);
        this.setStepSound(soundTypeCloth);
        this.setHardness(0.3f);
        this.setTickRandomly(true);
    }

    public void updateTick(World world, int x, int y, int z, Random random) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta == 0 && world.getWorldInfo().isRaining() && random.nextInt(20) == 0 && world.getBlock(x, y + 1, z) == Blocks.air) {
            switch (random.nextInt(4)) {
                case 0: {
                    if (world.getBlock(x + 1, y, z) != Blocks.air) break;
                    world.setBlock(x + 1, y, z, (Block)this, 5, 3);
                    break;
                }
                case 1: {
                    if (world.getBlock(x, y, z + 1) != Blocks.air) break;
                    world.setBlock(x, y, z + 1, (Block)this, 6, 3);
                    break;
                }
                case 2: {
                    if (world.getBlock(x - 1, y, z) != Blocks.air) break;
                    world.setBlock(x - 1, y, z, (Block)this, 3, 3);
                    break;
                }
                case 3: {
                    if (world.getBlock(x, y, z - 1) != Blocks.air) break;
                    world.setBlock(x, y, z - 1, (Block)this, 4, 3);
                }
            }
        } else if (meta == 2 && random.nextInt(200) == 0) {
            SaguaroGen gen = new SaguaroGen(NContent.saguaro, 0, true);
            gen.generate(world, random, x, y, z);
        } else if (meta == 1 && random.nextInt(200) == 0) {
            world.setBlockMetadataWithNotify(x, y, z, 2, 3);
        }
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta == 0) {
            float offset = 0.125f;
            return AxisAlignedBB.getBoundingBox((double)((float)x + offset), (double)y, (double)((float)z + offset), (double)((float)(x + 1) - offset), (double)((float)(y + 1) - offset), (double)((float)(z + 1) - offset));
        }
        if (meta == 1 || meta == 2) {
            float offset = 0.325f;
            return AxisAlignedBB.getBoundingBox((double)((float)x + offset), (double)y, (double)((float)z + offset), (double)((float)(x + 1) - offset), (double)((float)(y + 1) - offset), (double)((float)(z + 1) - offset));
        }
        if (meta == 3) {
            float offset = 0.25f;
            return AxisAlignedBB.getBoundingBox((double)((float)x + 0.625f), (double)((double)y + 0.1875), (double)((float)z + offset), (double)((float)x + 1.125f), (double)((double)y + 0.75), (double)((float)(z + 1) - offset));
        }
        if (meta == 4) {
            float offset = 0.25f;
            return AxisAlignedBB.getBoundingBox((double)((float)x + offset), (double)((double)y + 0.1875), (double)((float)z + 0.625f), (double)((float)(x + 1) - offset), (double)((double)y + 0.75), (double)((float)z + 1.125f));
        }
        if (meta == 5) {
            float offset = 0.25f;
            return AxisAlignedBB.getBoundingBox((double)((float)x - 0.125f), (double)((double)y + 0.1875), (double)((float)z + offset), (double)((float)x + 0.375f), (double)((double)y + 0.75), (double)((float)(z + 1) - offset));
        }
        if (meta == 6) {
            float offset = 0.25f;
            return AxisAlignedBB.getBoundingBox((double)((float)x + offset), (double)((double)y + 0.1875), (double)((float)z - 0.125f), (double)((float)(x + 1) - offset), (double)((double)y + 0.75), (double)((float)z + 0.375f));
        }
        return null;
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta == 0) {
            Block block;
            float offset = 0.125f;
            float height = 0.125f;
            float base = 0.0f;
            if (world.getBlock(x, y + 1, z) == this) {
                height = 0.0f;
            }
            if ((block = world.getBlock(x, y - 1, z)) != null && !block.isOpaqueCube()) {
                base = 0.125f;
            }
            return AxisAlignedBB.getBoundingBox((double)((float)x + offset), (double)y, (double)((float)z + offset), (double)((float)(x + 1) - offset), (double)((float)(y + 1) - height), (double)((float)(z + 1) - offset));
        }
        if (meta == 1 || meta == 2) {
            float offset = 0.325f;
            return AxisAlignedBB.getBoundingBox((double)((float)x + offset), (double)y, (double)((float)z + offset), (double)((float)(x + 1) - offset), (double)((double)y + 0.5), (double)((float)(z + 1) - offset));
        }
        if (meta == 3) {
            float offset = 0.25f;
            return AxisAlignedBB.getBoundingBox((double)((float)x + 0.625f), (double)((double)y + 0.1875), (double)((float)z + offset), (double)((float)x + 1.125f), (double)((double)y + 0.75), (double)((float)(z + 1) - offset));
        }
        if (meta == 4) {
            float offset = 0.25f;
            return AxisAlignedBB.getBoundingBox((double)((float)x + offset), (double)((double)y + 0.1875), (double)((float)z + 0.625f), (double)((float)(x + 1) - offset), (double)((double)y + 0.75), (double)((float)z + 1.125f));
        }
        if (meta == 5) {
            float offset = 0.25f;
            return AxisAlignedBB.getBoundingBox((double)((float)x - 0.125f), (double)((double)y + 0.1875), (double)((float)z + offset), (double)((float)x + 0.375f), (double)((double)y + 0.75), (double)((float)(z + 1) - offset));
        }
        if (meta == 6) {
            float offset = 0.25f;
            return AxisAlignedBB.getBoundingBox((double)((float)x + offset), (double)((double)y + 0.1875), (double)((float)z - 0.125f), (double)((float)(x + 1) - offset), (double)((double)y + 0.75), (double)((float)z + 0.375f));
        }
        return null;
    }

    public int getRenderType() {
        return SaguaroRenderer.model;
    }

    public static int func_72219_c(int par0) {
        return (par0 & 0xC) >> 2;
    }

    public static int getRotation(int meta) {
        return meta - 3;
    }

    public Item getItemDropped(int meta, Random random, int fortune) {
        if (meta == 0) {
            return Item.getItemFromBlock((Block)this);
        }
        return NContent.seedFood;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.icons = new IIcon[this.textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.registerIcon("natura:" + this.textureNames[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        if (meta == 0) {
            if (side < 2) {
                return this.icons[side];
            }
            return this.icons[2];
        }
        if (meta == 1 || meta == 2) {
            return this.icons[1];
        }
        return this.icons[3];
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean canPlaceBlockAt(World world, int i, int j, int k) {
        if (!super.canPlaceBlockAt(world, i, j, k)) {
            return false;
        }
        return this.canBlockStay(world, i, j, k);
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (!this.canBlockStay(world, i, j, k)) {
            this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k), 0);
            world.setBlockToAir(i, j, k);
        }
    }

    public boolean canBlockStay(World world, int x, int y, int z) {
        Block blockID = world.getBlock(x, y - 1, z);
        return blockID == this || blockID == Blocks.sand || blockID == null;
    }

    public void onEntityCollidedWithBlock(World world, int i, int j, int k, Entity entity) {
        if (!(entity instanceof EntityItem)) {
            entity.attackEntityFrom(DamageSource.cactus, 1.0f);
        }
    }

    public boolean canConnectSuguaroTo(IBlockAccess world, int x, int y, int z) {
        return world.getBlock(x, y, z) == this && world.getBlockMetadata(x, y, z) == 0;
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Desert;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return 1;
    }
}

