/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.client.block;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import mantle.world.CoordTuple;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;
import tmechworks.blocks.FilterBlock;

public class FilterRender
implements ISimpleBlockRenderingHandler {
    public static int renderID = RenderingRegistry.getNextAvailableRenderId();
    public static final double sideWidth = 0.2;
    public static final double thickness = 0.1875;

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        renderer.setRenderBounds(0.0, 0.0, 0.0, 0.2, 0.1875, 1.0);
        this.renderStandardBlockInv(block, metadata, renderer);
        renderer.setRenderBounds(0.8, 0.0, 0.0, 1.0, 0.1875, 1.0);
        this.renderStandardBlockInv(block, metadata, renderer);
        renderer.setRenderBounds(0.2, 0.0, 0.0, 0.8, 0.1875, 0.2);
        this.renderStandardBlockInv(block, metadata, renderer);
        renderer.setRenderBounds(0.2, 0.0, 0.8, 0.8, 0.1875, 1.0);
        this.renderStandardBlockInv(block, metadata, renderer);
        FilterBlock fb = (FilterBlock)block;
        if (fb.getMeshIcon(metadata) != null) {
            renderer.setOverrideBlockTexture(fb.getMeshIcon(metadata));
            renderer.setRenderBounds(0.2, 0.09375, 0.2, 0.8, 0.11374999955296516, 0.8);
            this.renderStandardBlockInv(block, metadata, renderer);
            renderer.clearOverrideBlockTexture();
        }
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelID, RenderBlocks renderer) {
        if (modelID == renderID) {
            CoordTuple position = new CoordTuple((double)x, (double)y, (double)z);
            int metadata = world.getBlockMetadata(position.x, position.y, position.z);
            FilterBlock fb = (FilterBlock)block;
            double bottom = 0.0;
            double top = 0.1875;
            if (fb.isTop(world, position)) {
                bottom = 0.8125;
                top = 1.0;
            }
            renderer.setRenderBounds(0.0, bottom, 0.0, 0.2, top, 1.0);
            renderer.renderStandardBlock(block, position.x, position.y, position.z);
            renderer.setRenderBounds(0.8, bottom, 0.0, 1.0, top, 1.0);
            renderer.renderStandardBlock(block, position.x, position.y, position.z);
            renderer.setRenderBounds(0.2, bottom, 0.0, 0.8, top, 0.2);
            renderer.renderStandardBlock(block, position.x, position.y, position.z);
            renderer.setRenderBounds(0.2, bottom, 0.8, 0.8, top, 1.0);
            renderer.renderStandardBlock(block, position.x, position.y, position.z);
            if (fb.getMeshIcon(metadata) != null) {
                renderer.setOverrideBlockTexture(fb.getMeshIcon(metadata));
                renderer.setRenderBounds(0.2, bottom + 0.03125, 0.2, 0.8, top - 0.03125, 0.8);
                renderer.renderStandardBlock(block, position.x, position.y, position.z);
                renderer.clearOverrideBlockTexture();
            }
            return true;
        }
        return false;
    }

    public int getRenderId() {
        return renderID;
    }

    private void renderStandardBlockInv(Block block, int meta, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.instance;
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        renderer.renderFaceYNeg(block, 0.0, 0.0, 0.0, block.getIcon(0, meta));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        renderer.renderFaceYPos(block, 0.0, 0.0, 0.0, block.getIcon(1, meta));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        renderer.renderFaceZNeg(block, 0.0, 0.0, 0.0, block.getIcon(2, meta));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        renderer.renderFaceZPos(block, 0.0, 0.0, 0.0, block.getIcon(3, meta));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        renderer.renderFaceXNeg(block, 0.0, 0.0, 0.0, block.getIcon(4, meta));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        renderer.renderFaceXPos(block, 0.0, 0.0, 0.0, block.getIcon(5, meta));
        tessellator.draw();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }
}

