/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.items.blocks;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;

public class RedstoneMachineItem
extends ItemBlock {
    public static final String[] blockType = new String[]{"drawbridge", "firestarter", "advdrawbridge", "extdrawbridge"};

    public RedstoneMachineItem(Block b) {
        super(b);
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
    }

    public int getMetadata(int meta) {
        return meta;
    }

    public String getUnlocalizedName(ItemStack itemstack) {
        int pos = MathHelper.clamp_int((int)itemstack.getItemDamage(), (int)0, (int)(blockType.length - 1));
        return "block." + blockType[pos];
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        int meta = stack.getItemDamage();
        if (stack.hasTagCompound()) {
            if (meta != 1) {
                ItemStack camo;
                if (meta == 0 || meta == 3) {
                    ItemStack contents;
                    NBTTagCompound contentTags = stack.getTagCompound().getCompoundTag("Contents");
                    if (contentTags != null && (contents = ItemStack.loadItemStackFromNBT((NBTTagCompound)contentTags)) != null) {
                        list.add(StatCollector.translateToLocal((String)"tooltip.drawbridge.inventory") + "\u00a7f" + contents.getDisplayName());
                        list.add(StatCollector.translateToLocal((String)"tooltip.drawbridge.amount") + "\u00a7f" + contents.stackSize);
                    }
                } else if (meta == 2) {
                    for (int i = 1; i <= 16; ++i) {
                        NBTTagCompound contentTag = stack.getTagCompound().getCompoundTag("Slot" + i);
                        ItemStack contents = ItemStack.loadItemStackFromNBT((NBTTagCompound)contentTag);
                        if (contents == null) continue;
                        list.add(StatCollector.translateToLocal((String)"tooltip.drawbridge.slot") + i + ": \u00a7f" + contents.getDisplayName());
                    }
                }
                NBTTagCompound camoTag = stack.getTagCompound().getCompoundTag("Camoflauge");
                if (camoTag != null && (camo = ItemStack.loadItemStackFromNBT((NBTTagCompound)camoTag)) != null) {
                    list.add("\u00a72" + StatCollector.translateToLocal((String)"tooltip.drawbridge.camoflauge") + "\u00a7f" + camo.getDisplayName());
                }
                if (stack.getTagCompound().hasKey("Placement")) {
                    String string = this.getDirectionString(stack.getTagCompound().getByte("Placement"));
                    list.add(StatCollector.translateToLocal((String)"tooltip.drawbridge.direction") + string);
                }
            }
        } else if (meta != 1) {
            list.add(StatCollector.translateToLocal((String)"tooltip.drawbridge.default"));
        }
    }

    String getDirectionString(byte key) {
        if (key == 0) {
            return StatCollector.translateToLocal((String)"tooltip.drawbridge.direction.up");
        }
        if (key == 1) {
            return StatCollector.translateToLocal((String)"tooltip.drawbridge.direction.right");
        }
        if (key == 2) {
            return StatCollector.translateToLocal((String)"tooltip.drawbridge.direction.down");
        }
        return StatCollector.translateToLocal((String)"tooltip.drawbridge.direction.left");
    }
}

