/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.blocks.logic;

import mantle.blocks.iface.IActiveLogic;
import mantle.blocks.iface.IFacingLogic;
import mantle.world.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tconstruct.library.tools.AbilityHelper;

public class FirestarterLogic
extends TileEntity
implements IFacingLogic,
IActiveLogic {
    boolean active;
    boolean shouldActivate;
    byte direction;

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean flag) {
        this.active = flag;
        this.shouldActivate = true;
    }

    void setFire() {
        int xPos = this.xCoord;
        int yPos = this.yCoord;
        int zPos = this.zCoord;
        switch (this.direction) {
            case 0: {
                --yPos;
                break;
            }
            case 1: {
                ++yPos;
                break;
            }
            case 2: {
                --zPos;
                break;
            }
            case 3: {
                ++zPos;
                break;
            }
            case 4: {
                --xPos;
                break;
            }
            case 5: {
                ++xPos;
            }
        }
        Block block = this.worldObj.getBlock(xPos, yPos, zPos);
        if (this.active) {
            if (block == null || WorldHelper.isAirBlock((World)this.worldObj, (int)xPos, (int)yPos, (int)zPos)) {
                this.worldObj.playSoundEffect((double)xPos + 0.5, (double)yPos + 0.5, (double)zPos + 0.5, "fire.ignite", 1.0f, AbilityHelper.random.nextFloat() * 0.4f + 0.8f);
                this.worldObj.setBlock(xPos, yPos, zPos, (Block)Blocks.fire);
            }
        } else if (block == Blocks.fire) {
            this.worldObj.playSoundEffect((double)xPos + 0.5, (double)yPos + 0.5, (double)zPos + 0.5, "fire.ignite", 1.0f, AbilityHelper.random.nextFloat() * 0.4f + 0.8f);
            this.worldObj.setBlock(xPos, yPos, zPos, Blocks.air, 0, 3);
            this.shouldActivate = true;
        }
    }

    public void updateEntity() {
        if (this.shouldActivate) {
            this.shouldActivate = false;
            this.setFire();
        }
    }

    public byte getRenderDirection() {
        return this.direction;
    }

    public ForgeDirection getForgeDirection() {
        return ForgeDirection.VALID_DIRECTIONS[this.direction];
    }

    public void setDirection(int side) {
    }

    public void setDirection(float yaw, float pitch, EntityLivingBase player) {
        if (pitch > 45.0f) {
            this.direction = 1;
        } else if (pitch < -45.0f) {
            this.direction = 0;
        } else {
            int facing = MathHelper.floor_double((double)((double)(yaw / 360.0f) + 0.5)) & 3;
            switch (facing) {
                case 0: {
                    this.direction = (byte)2;
                    break;
                }
                case 1: {
                    this.direction = (byte)5;
                    break;
                }
                case 2: {
                    this.direction = (byte)3;
                    break;
                }
                case 3: {
                    this.direction = (byte)4;
                }
            }
        }
    }

    public void readFromNBT(NBTTagCompound tags) {
        super.readFromNBT(tags);
        tags.setBoolean("Active", this.active);
        this.readCustomNBT(tags);
    }

    public void writeToNBT(NBTTagCompound tags) {
        super.writeToNBT(tags);
        this.active = tags.getBoolean("Active");
        this.writeCustomNBT(tags);
    }

    public void readCustomNBT(NBTTagCompound tags) {
        this.direction = tags.getByte("Direction");
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        tags.setByte("Direction", this.direction);
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(tag);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.readCustomNBT(packet.func_148857_g());
        this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
    }
}

