/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.lib.multiblock;

import java.util.LinkedList;
import mantle.world.CoordTuple;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import tmechworks.lib.multiblock.IMultiblockMember;
import tmechworks.lib.multiblock.MultiblockMasterBaseLogic;
import tmechworks.lib.multiblock.MultiblockRegistry;

public abstract class MultiblockBaseLogic
extends TileEntity
implements IMultiblockMember {
    private MultiblockMasterBaseLogic master = null;
    private byte visited = 0;
    private static final byte kUnvisited = 0;
    private static final byte kVisited = 1;
    private boolean saveMultiblockData = false;
    private NBTTagCompound cachedMultiblockData = null;
    private boolean doUpdate = false;
    private boolean pendingDestroy = false;

    @Override
    public boolean isCompatible(Object other) {
        return other.getClass().equals(this.getClass());
    }

    public void doMultiblockTick() {
    }

    @Override
    public boolean isConnected() {
        return this.master != null;
    }

    @Override
    public boolean willConnect(CoordTuple coord) {
        return true;
    }

    @Override
    public MultiblockMasterBaseLogic getMultiblockMaster() {
        return this.master;
    }

    @Override
    public CoordTuple getCoordInWorld() {
        return new CoordTuple((double)this.xCoord, (double)this.yCoord, (double)this.zCoord);
    }

    @Override
    public void onAttached(MultiblockMasterBaseLogic newMaster) {
        this.master = newMaster;
    }

    @Override
    public void onDetached(MultiblockMasterBaseLogic oldMaster) {
        if (this.master != oldMaster) {
            throw new IllegalArgumentException("Detaching from wrong master");
        }
        this.master = null;
    }

    @Override
    public void createNewMultiblock() {
        MultiblockMasterBaseLogic newMaster = this.getNewMultiblockMasterObject();
        newMaster.attachBlock(this);
    }

    @Override
    public void onMasterMerged(MultiblockMasterBaseLogic newMaster) {
        assert (this.master != newMaster);
        this.master = newMaster;
    }

    @Override
    public void setVisited() {
        this.visited = 1;
    }

    @Override
    public void setUnivisted() {
        this.visited = 0;
    }

    @Override
    public boolean isVisited() {
        return this.visited != 0 || this.pendingDestroy;
    }

    @Override
    public void becomeMultiblockSaveDelegate() {
        this.saveMultiblockData = true;
    }

    @Override
    public void forfeitMultiblockSaveDelegate() {
        this.saveMultiblockData = false;
    }

    @Override
    public boolean isMultiblockSaveDelegate() {
        return this.saveMultiblockData;
    }

    @Override
    public IMultiblockMember[] getNeighboringMembers() {
        CoordTuple[] neighbors = this.getNeighborCoords();
        LinkedList<IMultiblockMember> neighborMembers = new LinkedList<IMultiblockMember>();
        for (CoordTuple neighbor : neighbors) {
            TileEntity te = this.worldObj.getTileEntity(neighbor.x, neighbor.y, neighbor.z);
            if (!(te instanceof IMultiblockMember) || !((IMultiblockMember)te).isCompatible(this) || !((IMultiblockMember)te).willConnect(this.getCoordInWorld())) continue;
            neighborMembers.add((IMultiblockMember)te);
        }
        IMultiblockMember[] tmp = new IMultiblockMember[neighborMembers.size()];
        return neighborMembers.toArray(tmp);
    }

    @Override
    public void onBlockAdded(World world, int x, int y, int z) {
        if (this.pendingDestroy) {
            return;
        }
        IMultiblockMember[] neighbors = this.getNeighboringMembers();
        LinkedList<MultiblockMasterBaseLogic> masters = new LinkedList<MultiblockMasterBaseLogic>();
        for (IMultiblockMember neighbor : neighbors) {
            if (!neighbor.isConnected() || masters.contains(neighbor.getMultiblockMaster())) continue;
            masters.add(neighbor.getMultiblockMaster());
        }
        if (masters.size() > 0) {
            MultiblockMasterBaseLogic targetMaster = null;
            for (MultiblockMasterBaseLogic candidateMaster : masters) {
                if (targetMaster == null) {
                    targetMaster = candidateMaster;
                    continue;
                }
                int comparison = targetMaster.getReferenceCoord().compareTo((Object)candidateMaster.getReferenceCoord());
                if (comparison < 0) continue;
                if (comparison == 0) {
                    throw new IllegalStateException(String.format("Found two controllers (hashes %d,  %d) with identical reference coord %s", targetMaster.hashCode(), candidateMaster.hashCode(), targetMaster.getReferenceCoord().toString()));
                }
                targetMaster = candidateMaster;
            }
            assert (targetMaster != null);
            masters.remove(targetMaster);
            targetMaster.attachBlock(this);
            if (masters.size() > 0) {
                this.master.beginMerging();
                for (MultiblockMasterBaseLogic masterToMerge : masters) {
                    this.master.merge(masterToMerge);
                }
                this.master.endMerging();
            }
        } else {
            this.createNewMultiblock();
        }
    }

    @Override
    public void onOrphaned() {
        CoordTuple[] neighborCoords;
        if (this.isConnected() || this.pendingDestroy) {
            return;
        }
        this.createNewMultiblock();
        LinkedList<IMultiblockMember> membersToCheck = new LinkedList<IMultiblockMember>();
        for (CoordTuple coord : neighborCoords = this.getNeighborCoords()) {
            TileEntity neighborTE = this.worldObj.getTileEntity(coord.x, coord.y, coord.z);
            if (!(neighborTE instanceof IMultiblockMember) || ((IMultiblockMember)neighborTE).isConnected() || !((IMultiblockMember)neighborTE).willConnect(this.getCoordInWorld())) continue;
            membersToCheck.add((IMultiblockMember)neighborTE);
        }
        while (!membersToCheck.isEmpty()) {
            IMultiblockMember[] neighborMembers;
            IMultiblockMember member = (IMultiblockMember)membersToCheck.remove();
            if (member.isConnected()) continue;
            this.master.attachBlock(member);
            for (IMultiblockMember neighbor : neighborMembers = member.getNeighboringMembers()) {
                if (neighbor.isConnected()) continue;
                membersToCheck.add(neighbor);
            }
        }
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.hasKey("multiblockData")) {
            this.cachedMultiblockData = data.getCompoundTag("multiblockData");
        }
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        if (this.saveMultiblockData) {
            NBTTagCompound multiblockData = new NBTTagCompound();
            this.master.writeToNBT(multiblockData);
            data.setTag("multiblockData", (NBTBase)multiblockData);
        }
    }

    public boolean canUpdate() {
        return false;
    }

    public void invalidate() {
        super.invalidate();
        this.detachSelf(false);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.worldObj.isRemote) {
            this.detachSelf(true);
        }
    }

    @Override
    public void onChunkLoad() {
        if (this.cachedMultiblockData != null) {
            MultiblockMasterBaseLogic newMaster = this.getNewMultiblockMasterObject();
            newMaster.restore(this.cachedMultiblockData);
            this.cachedMultiblockData = null;
            newMaster.attachBlock(this);
        } else if (!this.isConnected()) {
            this.onBlockAdded(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        }
    }

    @Override
    public void onChunkUnloaded() {
        this.detachSelf(true);
    }

    public void validate() {
        super.validate();
        if (!this.worldObj.isRemote) {
            MultiblockRegistry.registerMember(this.worldObj, ChunkCoordIntPair.chunkXZ2Int((int)(this.xCoord >> 4), (int)(this.zCoord >> 4)), this);
            if (!this.worldObj.getChunkProvider().chunkExists(this.xCoord >> 4, this.zCoord >> 4)) {
                boolean master = this.cachedMultiblockData != null;
                MultiblockRegistry.onMemberLoad(this.worldObj, ChunkCoordIntPair.chunkXZ2Int((int)(this.xCoord >> 4), (int)(this.zCoord >> 4)), this, master);
            }
        }
    }

    @Override
    public abstract MultiblockMasterBaseLogic getNewMultiblockMasterObject();

    protected void attachSelf(World world, MultiblockMasterBaseLogic newMaster) {
        this.master = newMaster;
        this.master.attachBlock(this);
    }

    protected void detachSelf(boolean chunkUnloading) {
        if (this.master != null) {
            this.master.detachBlock(this, chunkUnloading);
            this.master = null;
        }
    }

    protected void destroySelf() {
        this.pendingDestroy = true;
        this.getMultiblockMaster().scheduleRemoveAndRevisit(this);
    }

    protected CoordTuple[] getNeighborCoords() {
        return new CoordTuple[]{new CoordTuple((double)(this.xCoord - 1), (double)this.yCoord, (double)this.zCoord), new CoordTuple((double)this.xCoord, (double)(this.yCoord - 1), (double)this.zCoord), new CoordTuple((double)this.xCoord, (double)this.yCoord, (double)(this.zCoord - 1)), new CoordTuple((double)this.xCoord, (double)this.yCoord, (double)(this.zCoord + 1)), new CoordTuple((double)this.xCoord, (double)(this.yCoord + 1), (double)this.zCoord), new CoordTuple((double)(this.xCoord + 1), (double)this.yCoord, (double)this.zCoord)};
    }
}

