/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.blocks.logic;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import mantle.world.CoordTuple;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tmechworks.blocks.component.SignalBusMasterLogic;
import tmechworks.common.MechContent;
import tmechworks.lib.multiblock.IMultiblockMember;
import tmechworks.lib.multiblock.MultiblockBaseLogic;
import tmechworks.lib.multiblock.MultiblockMasterBaseLogic;
import tmechworks.lib.signal.ISignalBusConnectable;
import tmechworks.lib.signal.ISignalTransceiver;

public class SignalBusLogic
extends MultiblockBaseLogic
implements ISignalBusConnectable {
    private int ticks = 0;
    private Map<CoordTuple, byte[]> transceivers = new HashMap<CoordTuple, byte[]>();
    private byte[] localHighSignals = new byte[16];
    private byte[] cachedReceivedSignals = new byte[16];
    private int cachedConnectableCount = 0;
    private boolean southboundSignalsChanged = false;
    private boolean northboundSignalsChanged = false;
    private boolean forceCheck = false;
    private boolean[] placedSides = new boolean[]{false, false, false, false, false, false};

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public IMultiblockMember[] getNeighboringMembers() {
        LinkedList<IMultiblockMember> corners = new LinkedList<IMultiblockMember>();
        for (int i = 0; i < 6; ++i) {
            if (!this.placedSides[i]) continue;
            for (int j = 0; j < 6; ++j) {
                TileEntity te;
                int tZ;
                int tY;
                int tX;
                if (j == i || j == ForgeDirection.OPPOSITES[i] || this.worldObj.getBlock(tX = ForgeDirection.VALID_DIRECTIONS[j].offsetX + this.xCoord, tY = ForgeDirection.VALID_DIRECTIONS[j].offsetY + this.yCoord, tZ = ForgeDirection.VALID_DIRECTIONS[j].offsetZ + this.zCoord).isOpaqueCube() || !((te = this.worldObj.getTileEntity(tX += ForgeDirection.VALID_DIRECTIONS[i].offsetX, tY += ForgeDirection.VALID_DIRECTIONS[i].offsetY, tZ += ForgeDirection.VALID_DIRECTIONS[i].offsetZ)) instanceof IMultiblockMember) || !((IMultiblockMember)te).isCompatible(this) || !((IMultiblockMember)te).willConnect(this.getCoordInWorld())) continue;
                corners.add((IMultiblockMember)te);
            }
        }
        corners.addAll(Arrays.asList(super.getNeighboringMembers()));
        IMultiblockMember[] tmp = new IMultiblockMember[corners.size()];
        return corners.toArray(tmp);
    }

    public void broadcastSouthboundSignals() {
        if (this.southboundSignalsChanged) {
            TileEntity te = null;
            for (CoordTuple coord : this.transceivers.keySet()) {
                if (!this.worldObj.getChunkProvider().chunkExists(coord.x >> 4, coord.z >> 4) || !((te = this.worldObj.getTileEntity(coord.x, coord.y, coord.z)) instanceof ISignalTransceiver)) continue;
                ((ISignalTransceiver)te).receiveSignalUpdate(this.cachedReceivedSignals);
            }
            this.southboundSignalsChanged = false;
        }
    }

    public void multiBlockTick() {
    }

    public void updateEntity() {
        if (this.worldObj.isRemote) {
            return;
        }
        if (!this.isConnected()) {
            return;
        }
        if (this.forceCheck) {
            int connectableCount = this.getNeighboringMembers().length;
            this.forceCheck = false;
            if (connectableCount != this.cachedConnectableCount) {
                this.cachedConnectableCount = connectableCount;
                super.onBlockAdded(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
            }
        }
        if (this.northboundSignalsChanged) {
            this.localHighSignals = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            for (CoordTuple coord : this.transceivers.keySet()) {
                byte[] signals = this.transceivers.get(coord);
                if (signals[0] > this.localHighSignals[0]) {
                    this.localHighSignals[0] = signals[0];
                }
                if (signals[1] > this.localHighSignals[1]) {
                    this.localHighSignals[1] = signals[1];
                }
                if (signals[2] > this.localHighSignals[2]) {
                    this.localHighSignals[2] = signals[2];
                }
                if (signals[3] > this.localHighSignals[3]) {
                    this.localHighSignals[3] = signals[3];
                }
                if (signals[4] > this.localHighSignals[4]) {
                    this.localHighSignals[4] = signals[4];
                }
                if (signals[5] > this.localHighSignals[5]) {
                    this.localHighSignals[5] = signals[5];
                }
                if (signals[6] > this.localHighSignals[6]) {
                    this.localHighSignals[6] = signals[6];
                }
                if (signals[7] > this.localHighSignals[7]) {
                    this.localHighSignals[7] = signals[7];
                }
                if (signals[8] > this.localHighSignals[8]) {
                    this.localHighSignals[8] = signals[8];
                }
                if (signals[9] > this.localHighSignals[9]) {
                    this.localHighSignals[9] = signals[9];
                }
                if (signals[10] > this.localHighSignals[10]) {
                    this.localHighSignals[10] = signals[10];
                }
                if (signals[11] > this.localHighSignals[11]) {
                    this.localHighSignals[11] = signals[11];
                }
                if (signals[12] > this.localHighSignals[12]) {
                    this.localHighSignals[12] = signals[12];
                }
                if (signals[13] > this.localHighSignals[13]) {
                    this.localHighSignals[13] = signals[13];
                }
                if (signals[14] > this.localHighSignals[14]) {
                    this.localHighSignals[14] = signals[14];
                }
                if (signals[15] <= this.localHighSignals[15]) continue;
                this.localHighSignals[15] = signals[15];
            }
            ((SignalBusMasterLogic)this.getMultiblockMaster()).updateBusSignals(this.getCoordInWorld(), this.localHighSignals);
            this.northboundSignalsChanged = false;
        }
        this.broadcastSouthboundSignals();
    }

    public boolean registerTerminal(World world, int x, int y, int z, boolean rehome) {
        if (this.worldObj.isRemote) {
            return false;
        }
        if (world == this.worldObj && world.isRemote == this.worldObj.isRemote && this.worldObj.getTileEntity(x, y, z) instanceof ISignalTransceiver) {
            TileEntity te = world.getTileEntity(x, y, z);
            CoordTuple coords = new CoordTuple((double)x, (double)y, (double)z);
            byte[] signals = null;
            if (this.transceivers.containsKey(coords)) {
                return !rehome;
            }
            int dropWire = ((ISignalTransceiver)te).doUnregister(rehome);
            if (dropWire > 0) {
                Random rand = new Random();
                ItemStack tempStack = new ItemStack(MechContent.lengthWire, dropWire);
                float jumpX = rand.nextFloat() * 0.8f + 0.1f;
                float jumpY = rand.nextFloat() * 0.8f + 0.1f;
                float jumpZ = rand.nextFloat() * 0.8f + 0.1f;
                EntityItem entityitem = new EntityItem(world, (double)((float)this.xCoord + jumpX), (double)((float)this.yCoord + jumpY), (double)((float)this.zCoord + jumpZ), tempStack);
                float offset = 0.05f;
                entityitem.motionX = (float)rand.nextGaussian() * offset;
                entityitem.motionY = (float)rand.nextGaussian() * offset + 0.2f;
                entityitem.motionZ = (float)rand.nextGaussian() * offset;
                world.spawnEntityInWorld((Entity)entityitem);
            }
            ((ISignalTransceiver)te).setBusCoords(world, this.xCoord, this.yCoord, this.zCoord);
            signals = ((ISignalTransceiver)te).getReceivedSignals();
            this.transceivers.put(coords, signals);
            this.northboundSignalsChanged = true;
            if (this.getMultiblockMaster() instanceof MultiblockMasterBaseLogic) {
                this.updateLocalSignals(((SignalBusMasterLogic)this.getMultiblockMaster()).getSignals());
            }
            ((ISignalTransceiver)te).receiveSignalUpdate(this.cachedReceivedSignals);
            return true;
        }
        return false;
    }

    @Override
    public void onDetached(MultiblockMasterBaseLogic oldMaster) {
        super.onDetached(oldMaster);
    }

    @Override
    public void onAttached(MultiblockMasterBaseLogic newMaster) {
        super.onAttached(newMaster);
        if (this.transceivers != null || !this.transceivers.isEmpty()) {
            this.northboundSignalsChanged = true;
            this.updateLocalSignals(((SignalBusMasterLogic)this.getMultiblockMaster()).getSignals());
        }
    }

    public boolean isRegisteredTerminal(World world, int x, int y, int z) {
        if (this.worldObj.isRemote) {
            return false;
        }
        return this.transceivers.containsKey(new CoordTuple((double)x, (double)y, (double)z));
    }

    public boolean unregisterTerminal(World world, int x, int y, int z) {
        if (this.worldObj.isRemote) {
            return false;
        }
        if (this.transceivers.remove(new CoordTuple((double)x, (double)y, (double)z)) != null) {
            this.northboundSignalsChanged = true;
            return true;
        }
        return false;
    }

    public boolean hasTerminals() {
        return this.transceivers.size() > 0;
    }

    @Override
    public boolean isCompatible(Object other) {
        return other.getClass() == this.getClass();
    }

    @Override
    public void readFromNBT(NBTTagCompound tags) {
        super.readFromNBT(tags);
        this.readCustomNBT(tags);
    }

    public void readCustomNBT(NBTTagCompound tags) {
        int temp = tags.getInteger("placedSides");
        for (int i = 0; i < 6; ++i) {
            this.placedSides[i] = (temp >> i & 1) == 1;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tags) {
        super.writeToNBT(tags);
        this.writeCustomNBT(tags);
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        int temp = 0;
        for (int i = 0; i < 6; ++i) {
            if (!this.placedSides[i]) continue;
            temp |= 1 << i;
        }
        tags.setInteger("placedSides", temp);
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(tag);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.readCustomNBT(packet.func_148857_g());
        this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
    }

    public boolean[] placedSides() {
        return (boolean[])this.placedSides.clone();
    }

    public boolean[] connectedSides(ForgeDirection fromFace) {
        boolean[] connected = new boolean[6];
        for (int i = 0; i < 6; ++i) {
            if (i == fromFace.ordinal() || i == fromFace.getOpposite().ordinal()) continue;
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            int neighborX = this.xCoord + dir.offsetX;
            int neighborY = this.yCoord + dir.offsetY;
            int neighborZ = this.zCoord + dir.offsetZ;
            TileEntity te = this.worldObj.getTileEntity(neighborX, neighborY, neighborZ);
            connected[i] = te instanceof ISignalBusConnectable && ((ISignalBusConnectable)te).connectableOnFace(fromFace);
        }
        return connected;
    }

    @Override
    public boolean connectableOnFace(ForgeDirection side) {
        return this.placedSides[side.ordinal()];
    }

    public boolean isConnected(ForgeDirection side, ForgeDirection dir) {
        switch (dir) {
            case DOWN: {
                return this.worldObj.getTileEntity(this.xCoord, this.yCoord - 1, this.zCoord) instanceof SignalBusLogic;
            }
            case NORTH: {
                return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord - 1) instanceof SignalBusLogic;
            }
            case SOUTH: {
                return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord + 1) instanceof SignalBusLogic;
            }
            case WEST: {
                return this.worldObj.getTileEntity(this.xCoord - 1, this.yCoord, this.zCoord) instanceof SignalBusLogic;
            }
            case EAST: {
                return this.worldObj.getTileEntity(this.xCoord + 1, this.yCoord, this.zCoord) instanceof SignalBusLogic;
            }
        }
        return false;
    }

    @Override
    public MultiblockMasterBaseLogic getNewMultiblockMasterObject() {
        return new SignalBusMasterLogic(this.worldObj);
    }

    public byte[] getLocalSignals() {
        return this.localHighSignals;
    }

    public void updateTransceiverSignals(CoordTuple coords, byte[] signals) {
        if (!Arrays.equals(signals, this.transceivers.get(coords))) {
            this.transceivers.put(coords, signals);
            this.northboundSignalsChanged = true;
        }
    }

    public void updateLocalSignals(byte[] signals) {
        if (!Arrays.equals(signals, this.cachedReceivedSignals)) {
            this.cachedReceivedSignals = (byte[])signals.clone();
            this.southboundSignalsChanged = true;
        }
    }

    public void addPlacedSide(int side) {
        this.placedSides[side] = true;
        if (!this.worldObj.isRemote) {
            this.forceCheck = true;
        }
    }

    public boolean[] getRenderCorners(ForgeDirection fromFace) {
        boolean[] corners = new boolean[6];
        for (int i = 0; i < 6; ++i) {
            if (i == fromFace.ordinal() || i == fromFace.getOpposite().ordinal()) continue;
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            int neighborX = this.xCoord + dir.offsetX;
            int neighborY = this.yCoord + dir.offsetY;
            int neighborZ = this.zCoord + dir.offsetZ;
            if (this.worldObj.getBlock(neighborX, neighborY, neighborZ).isOpaqueCube()) continue;
            TileEntity te = this.worldObj.getTileEntity(neighborX += fromFace.offsetX, neighborY += fromFace.offsetY, neighborZ += fromFace.offsetZ);
            corners[i] = te instanceof ISignalBusConnectable && ((ISignalBusConnectable)te).connectableOnCorner(fromFace.getOpposite(), dir.getOpposite());
        }
        return corners;
    }

    @Override
    public boolean connectableOnCorner(ForgeDirection side, ForgeDirection turn) {
        return !this.placedSides[side.ordinal()] && this.placedSides[turn.ordinal()];
    }

    @Override
    public boolean willConnect(CoordTuple coord) {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection iDir = ForgeDirection.VALID_DIRECTIONS[i];
            if (!this.placedSides[i]) continue;
            for (int j = 0; j < 6; ++j) {
                TileEntity te;
                if (this.placedSides[j] || j == i || j == iDir.getOpposite().ordinal()) continue;
                ForgeDirection jDir = ForgeDirection.VALID_DIRECTIONS[j];
                if (this.xCoord + jDir.offsetX == coord.x && this.yCoord + jDir.offsetY == coord.y && this.zCoord + jDir.offsetZ == coord.z && (te = this.worldObj.getTileEntity(this.xCoord + jDir.offsetX, this.yCoord + jDir.offsetY, this.zCoord + jDir.offsetZ)) instanceof ISignalBusConnectable && ((ISignalBusConnectable)te).connectableOnFace(iDir)) {
                    return true;
                }
                if (this.worldObj.getBlock(this.xCoord + jDir.offsetX, this.yCoord + jDir.offsetY, this.zCoord + jDir.offsetZ).isOpaqueCube() || this.xCoord + iDir.offsetX + jDir.offsetX != coord.x || this.yCoord + iDir.offsetY + jDir.offsetY != coord.y || this.zCoord + iDir.offsetZ + jDir.offsetZ != coord.z || !((te = this.worldObj.getTileEntity(this.xCoord + iDir.offsetX + jDir.offsetX, this.yCoord + iDir.offsetY + jDir.offsetY, this.zCoord + iDir.offsetZ + jDir.offsetZ)) instanceof ISignalBusConnectable) || !((ISignalBusConnectable)te).connectableOnCorner(iDir.getOpposite(), jDir.getOpposite())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected CoordTuple[] getNeighborCoords() {
        LinkedList<CoordTuple> cornerCoords = new LinkedList<CoordTuple>();
        for (int i = 0; i < 6; ++i) {
            if (!this.placedSides[i]) continue;
            ForgeDirection iDir = ForgeDirection.VALID_DIRECTIONS[i];
            for (int j = 0; j < 6; ++j) {
                if (this.placedSides[j] || j == i || j == iDir.getOpposite().ordinal()) continue;
                ForgeDirection jDir = ForgeDirection.VALID_DIRECTIONS[j];
                if (this.worldObj.getBlock(this.xCoord + jDir.offsetX, this.yCoord + jDir.offsetY, this.zCoord + jDir.offsetZ).isOpaqueCube()) continue;
                cornerCoords.add(new CoordTuple((double)(this.xCoord + iDir.offsetX + jDir.offsetX), (double)(this.yCoord + iDir.offsetY + jDir.offsetY), (double)(this.zCoord + iDir.offsetZ + jDir.offsetZ)));
            }
        }
        cornerCoords.addAll(Arrays.asList(super.getNeighborCoords()));
        CoordTuple[] tmp = new CoordTuple[cornerCoords.size()];
        return cornerCoords.toArray(tmp);
    }

    public void forceNeighborCheck() {
        this.forceCheck = true;
    }

    public int getDroppedBuses() {
        int calc = 0;
        for (int i = 0; i < 6; ++i) {
            if (!this.placedSides[i]) continue;
            ++calc;
        }
        return calc;
    }

    public int getDroppedWire() {
        int calc = 0;
        for (CoordTuple coord : this.transceivers.keySet()) {
            TileEntity te = this.worldObj.getTileEntity(coord.x, coord.y, coord.z);
            if (!(te instanceof ISignalTransceiver)) continue;
            calc += ((ISignalTransceiver)te).getDroppedWire();
        }
        return calc;
    }

    public void notifyBreak() {
        CoordTuple[] scan = new CoordTuple[this.transceivers.keySet().size()];
        for (CoordTuple coord : scan = this.transceivers.keySet().toArray(scan)) {
            TileEntity te = this.worldObj.getTileEntity(coord.x, coord.y, coord.z);
            if (!(te instanceof ISignalTransceiver)) continue;
            ((ISignalTransceiver)te).doUnregister(true);
        }
        this.destroySelf();
    }

    public boolean canPlaceOnSide(int side) {
        for (int i = 0; i < 6; ++i) {
            if (i == side || i == ForgeDirection.OPPOSITES[side] || !this.placedSides[i]) continue;
            return true;
        }
        return false;
    }

    public int checkUnsupportedSides() {
        int dropCount = 0;
        for (int i = 0; i < 6; ++i) {
            if (!this.placedSides[i]) continue;
            ForgeDirection iDir = ForgeDirection.VALID_DIRECTIONS[i];
            ForgeDirection sDir = ForgeDirection.VALID_DIRECTIONS[i].getOpposite();
            if (sDir == ForgeDirection.NORTH || sDir == ForgeDirection.SOUTH) {
                sDir = sDir.getOpposite();
            }
            if (this.worldObj.isSideSolid(this.xCoord + iDir.offsetX, this.yCoord + iDir.offsetY, this.zCoord + iDir.offsetZ, iDir.getOpposite())) continue;
            this.placedSides[i] = false;
            ++dropCount;
        }
        return dropCount;
    }

    public boolean checkShouldDestroy() {
        for (int i = 0; i < 6; ++i) {
            if (!this.placedSides[i]) continue;
            return false;
        }
        return true;
    }
}

