/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.blocks.logic;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import mantle.blocks.BlockUtils;
import mantle.blocks.abstracts.InventoryLogic;
import mantle.blocks.iface.IActiveLogic;
import mantle.blocks.iface.IFacingLogic;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Facing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tmechworks.inventory.DrawbridgeContainer;
import tmechworks.lib.TMechworksRegistry;
import tmechworks.lib.blocks.IDrawbridgeLogicBase;
import tmechworks.lib.player.FakePlayerLogic;

public class DrawbridgeLogic
extends InventoryLogic
implements IFacingLogic,
IActiveLogic,
IDrawbridgeLogicBase {
    boolean active;
    boolean working;
    int ticks;
    byte extension;
    byte maxExtension = (byte)15;
    byte direction;
    byte placementDirection = (byte)4;
    FakePlayerLogic fakePlayer;
    ItemStack bufferStack = null;

    public DrawbridgeLogic() {
        super(2);
    }

    public void invalidate() {
        this.tileEntityInvalid = true;
        this.fakePlayer = null;
    }

    private void initFakePlayer() {
        if (this.fakePlayer == null && !this.isInvalid()) {
            this.fakePlayer = new FakePlayerLogic(new GameProfile(null, "Player.Drawbridge"), (TileEntity)this);
        }
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean flag) {
        this.active = flag;
        this.working = true;
    }

    public byte getRenderDirection() {
        return this.direction;
    }

    public ForgeDirection getForgeDirection() {
        return ForgeDirection.VALID_DIRECTIONS[this.direction];
    }

    public void setDirection(int side) {
    }

    public boolean canDropInventorySlot(int slot) {
        return false;
    }

    public void setMaximumExtension(byte length) {
        this.maxExtension = length;
    }

    public void setDirection(float yaw, float pitch, EntityLivingBase player) {
        if (pitch > 45.0f) {
            this.direction = 1;
        } else if (pitch < -45.0f) {
            this.direction = 0;
        } else {
            int facing = MathHelper.floor_double((double)((double)(yaw / 360.0f) + 0.5)) & 3;
            switch (facing) {
                case 0: {
                    this.direction = (byte)2;
                    break;
                }
                case 1: {
                    this.direction = (byte)5;
                    break;
                }
                case 2: {
                    this.direction = (byte)3;
                    break;
                }
                case 3: {
                    this.direction = (byte)4;
                }
            }
        }
    }

    public void setPlacementDirection(byte keycode) {
        this.placementDirection = keycode;
        if (!this.worldObj.isRemote) {
            this.initFakePlayer();
            this.setFakePlayerRotation();
        }
    }

    private void setFakePlayerRotation() {
        if (this.placementDirection == 4) {
            this.fakePlayer.rotationYaw = 0.0f;
            this.fakePlayer.rotationPitch = 0.0f;
        } else if (this.direction == 0 || this.direction == 1) {
            switch (this.placementDirection) {
                case 0: {
                    this.fakePlayer.rotationYaw = 0.0f;
                    break;
                }
                case 1: {
                    this.fakePlayer.rotationYaw = 90.0f;
                    break;
                }
                case 2: {
                    this.fakePlayer.rotationYaw = 180.0f;
                    break;
                }
                case 3: {
                    this.fakePlayer.rotationYaw = 270.0f;
                }
            }
            this.fakePlayer.rotationPitch = this.direction == 0 ? -90.0f : 90.0f;
        } else if (this.placementDirection == 0) {
            this.fakePlayer.rotationYaw = this.mapDirection() * 90;
            this.fakePlayer.rotationPitch = this.placementDirection == 0 ? 90.0f : -90.0f;
        } else if (this.placementDirection == 2) {
            int face = this.mapDirection() + 2;
            if (face > 3) {
                face -= 4;
            }
            this.fakePlayer.rotationYaw = face * 90;
            this.fakePlayer.rotationPitch = this.placementDirection == 0 ? 90.0f : -90.0f;
        } else {
            this.fakePlayer.rotationPitch = 0.0f;
            int facing = this.mapDirection();
            facing = this.placementDirection == 1 ? ++facing : --facing;
            if (facing >= 4) {
                facing = 0;
            }
            if (facing < 0) {
                facing = 3;
            }
            this.fakePlayer.rotationYaw = facing * 90;
        }
    }

    int mapDirection() {
        if (this.direction == 2) {
            return 0;
        }
        if (this.direction == 5) {
            return 1;
        }
        if (this.direction == 3) {
            return 2;
        }
        return 3;
    }

    @Override
    public byte getPlacementDirection() {
        return this.placementDirection;
    }

    public Container getGuiContainer(InventoryPlayer inventoryplayer, World world, int x, int y, int z) {
        return new DrawbridgeContainer(inventoryplayer, this);
    }

    protected String getDefaultName() {
        return "tmechworks.drawbridge";
    }

    public void setInventorySlotContents(int slot, ItemStack itemstack) {
        super.setInventorySlotContents(slot, itemstack);
        if (slot == 1) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    public ItemStack decrStackSize(int slot, int quantity) {
        ItemStack stack = super.decrStackSize(slot, quantity);
        if (slot == 1) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
        return stack;
    }

    public void updateEntity() {
        if (this.working && !this.isInvalid() && !this.worldObj.isRemote) {
            ++this.ticks;
            if (this.ticks == 5) {
                this.ticks = 0;
                if (this.active) {
                    if (this.inventory[0] != null && this.inventory[0].stackSize > 0 && this.extension < this.maxExtension) {
                        this.extension = (byte)(this.extension + 1);
                        int xPos = this.xCoord;
                        int yPos = this.yCoord;
                        int zPos = this.zCoord;
                        this.bufferStack = this.inventory[0].copy();
                        this.bufferStack.stackSize = 1;
                        switch (this.direction) {
                            case 0: {
                                yPos -= this.extension;
                                break;
                            }
                            case 1: {
                                yPos += this.extension;
                                break;
                            }
                            case 2: {
                                zPos -= this.extension;
                                break;
                            }
                            case 3: {
                                zPos += this.extension;
                                break;
                            }
                            case 4: {
                                xPos -= this.extension;
                                break;
                            }
                            case 5: {
                                xPos += this.extension;
                            }
                        }
                        if (xPos < -30000000 || zPos < -30000000 || xPos >= 30000000 || zPos >= 30000000 || yPos < 0 || yPos >= 256) {
                            this.extension = (byte)(this.extension - 1);
                            this.working = false;
                            return;
                        }
                        Block block = this.worldObj.getBlock(xPos, yPos, zPos);
                        if (block == null || block.isAir((IBlockAccess)this.worldObj, xPos, yPos, zPos) || block.canPlaceBlockAt(this.worldObj, xPos, yPos, zPos)) {
                            List list;
                            Block placeBlock;
                            this.initFakePlayer();
                            this.setFakePlayerRotation();
                            Item blockToItem = (Item)TMechworksRegistry.blockToItemMapping.get((Object)Item.getIdFromItem((Item)this.bufferStack.getItem()));
                            if (blockToItem == Item.getItemFromBlock((Block)Blocks.air)) {
                                if (Block.getBlockFromItem((Item)this.inventory[0].getItem()) == null) {
                                    return;
                                }
                                placeBlock = Block.getBlockFromItem((Item)this.bufferStack.getItem());
                                this.placeBlockAt(this.bufferStack, (EntityPlayer)this.fakePlayer, this.worldObj, xPos, yPos, zPos, this.direction, 0.0f, 0.0f, 0.0f, this.bufferStack.getItemDamage(), placeBlock);
                            } else {
                                placeBlock = Block.getBlockFromItem((Item)blockToItem);
                                this.placeBlockAt(this.bufferStack, (EntityPlayer)this.fakePlayer, this.worldObj, xPos, yPos, zPos, this.direction, 0.0f, 0.0f, 0.0f, this.bufferStack.getItemDamage(), placeBlock);
                            }
                            this.worldObj.playSoundEffect((double)xPos + 0.5, (double)yPos + 0.5, (double)zPos + 0.5, "tile.piston.out", 0.25f, this.worldObj.rand.nextFloat() * 0.25f + 0.6f);
                            ArrayList pushedObjects = new ArrayList();
                            AxisAlignedBB axisalignedbb = Block.getBlockFromItem((Item)this.bufferStack.getItem()).getCollisionBoundingBoxFromPool(this.worldObj, xPos, yPos, zPos);
                            if (axisalignedbb != null && !(list = this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)null, axisalignedbb)).isEmpty()) {
                                pushedObjects.addAll(list);
                                for (Entity entity : pushedObjects) {
                                    entity.moveEntity((double)Facing.offsetsXForSide[this.direction], (double)Facing.offsetsYForSide[this.direction], (double)Facing.offsetsZForSide[this.direction]);
                                }
                                pushedObjects.clear();
                            }
                            this.decrStackSize(0, 1);
                        } else {
                            this.extension = (byte)(this.extension - 1);
                            this.working = false;
                        }
                    } else {
                        this.working = false;
                    }
                } else if ((this.inventory[0] == null || this.inventory[0].stackSize < this.inventory[0].getMaxStackSize()) && this.extension > 0) {
                    int xPos = this.xCoord;
                    int yPos = this.yCoord;
                    int zPos = this.zCoord;
                    switch (this.direction) {
                        case 0: {
                            yPos -= this.extension;
                            break;
                        }
                        case 1: {
                            yPos += this.extension;
                            break;
                        }
                        case 2: {
                            zPos -= this.extension;
                            break;
                        }
                        case 3: {
                            zPos += this.extension;
                            break;
                        }
                        case 4: {
                            xPos -= this.extension;
                            break;
                        }
                        case 5: {
                            xPos += this.extension;
                        }
                    }
                    Block block = this.worldObj.getBlock(xPos, yPos, zPos);
                    if (block != null) {
                        int meta = this.worldObj.getBlockMetadata(xPos, yPos, zPos);
                        if (this.bufferStack != null && this.validBlock(block) && this.validMetadata(block, meta) && this.validDrawbridge(xPos, yPos, zPos)) {
                            this.worldObj.playSoundEffect((double)xPos + 0.5, (double)yPos + 0.5, (double)zPos + 0.5, "tile.piston.in", 0.25f, this.worldObj.rand.nextFloat() * 0.15f + 0.6f);
                            if (this.worldObj.setBlock(xPos, yPos, zPos, Blocks.air)) {
                                if (this.inventory[0] == null) {
                                    this.inventory[0] = this.bufferStack.copy();
                                } else {
                                    ++this.inventory[0].stackSize;
                                }
                            }
                        } else {
                            this.working = false;
                        }
                    }
                    this.extension = (byte)(this.extension - 1);
                } else {
                    this.working = false;
                }
            }
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata, Block block) {
        Item blockItem = stack.getItem();
        metadata = blockItem.getMetadata(metadata);
        metadata = block.onBlockPlaced(world, x, y, z, side, hitX, hitY, hitZ, metadata);
        if (blockItem instanceof ItemBlock) {
            return ((ItemBlock)blockItem).placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata);
        }
        if (!world.setBlock(x, y, z, block, metadata, 3)) {
            return false;
        }
        if (world.getBlock(x, y, z) == block) {
            block.onBlockPlacedBy(world, x, y, z, (EntityLivingBase)player, stack);
            block.onPostBlockPlaced(world, x, y, z, metadata);
        }
        return true;
    }

    boolean validDrawbridge(int x, int y, int z) {
        TileEntity te = this.worldObj.getTileEntity(x, y, z);
        return !(te instanceof IDrawbridgeLogicBase) || !((IDrawbridgeLogicBase)te).hasExtended();
    }

    boolean validBlock(Block block) {
        Block type = TMechworksRegistry.interchangableBlockMapping.get(new ItemStack(block).getItem());
        if (type != Blocks.air && type == Block.getBlockFromItem((Item)this.bufferStack.getItem())) {
            return true;
        }
        Item blockToItem = (Item)TMechworksRegistry.blockToItemMapping.get((Object)new ItemStack(block).getItem());
        if (blockToItem != Item.getItemFromBlock((Block)Blocks.air) && blockToItem == this.bufferStack.getItem()) {
            return true;
        }
        return new ItemStack(block).getItem() == this.bufferStack.getItem();
    }

    boolean validMetadata(Block block, int metadata) {
        return true;
    }

    public void readFromNBT(NBTTagCompound tags) {
        super.readFromNBT(tags);
        this.active = tags.getBoolean("Active");
        this.working = tags.getBoolean("Working");
        this.extension = tags.getByte("Extension");
        this.maxExtension = tags.getByte("MaxExtension");
        NBTTagCompound bufferInv = (NBTTagCompound)tags.getTag("BufferInv");
        if (bufferInv != null) {
            this.bufferStack = ItemStack.loadItemStackFromNBT((NBTTagCompound)bufferInv);
        }
        if (this.bufferStack == null && this.inventory[0] != null) {
            this.bufferStack = this.inventory[0];
        }
        this.readCustomNBT(tags);
    }

    public void writeToNBT(NBTTagCompound tags) {
        super.writeToNBT(tags);
        tags.setBoolean("Active", this.active);
        tags.setBoolean("Working", this.working);
        tags.setByte("Extension", this.extension);
        tags.setByte("MaxExtension", this.maxExtension);
        if (this.bufferStack != null) {
            NBTTagCompound bufferInv = new NBTTagCompound();
            this.bufferStack.writeToNBT(bufferInv);
            tags.setTag("BufferInv", (NBTBase)bufferInv);
        }
        this.writeCustomNBT(tags);
    }

    public void readCustomNBT(NBTTagCompound tags) {
        this.direction = tags.getByte("Direction");
        this.placementDirection = tags.getByte("Placement");
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        tags.setByte("Direction", this.direction);
        tags.setByte("Placement", this.placementDirection);
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.readFromNBT(packet.func_148857_g());
        this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public boolean hasExtended() {
        return this.extension != 0;
    }

    public void markDirty() {
        super.markDirty();
        if (this.getStackInSlot(0) != null) {
            this.bufferStack = this.getStackInSlot(0).copy();
            this.bufferStack.stackSize = 1;
        }
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
    }

    public String getInventoryName() {
        return null;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slot, ItemStack itemstack) {
        if (itemstack == null || !(itemstack.getItem() instanceof ItemBlock) || this.hasExtended()) {
            return false;
        }
        if (slot == 1) {
            if (this.inventory[slot] != null || itemstack.stackSize > 1) {
                return false;
            }
            Block block = BlockUtils.getBlockFromItemStack((ItemStack)itemstack);
            return block.isOpaqueCube() && block.renderAsNormalBlock();
        }
        if (TMechworksRegistry.isItemDBBlacklisted((ItemBlock)itemstack.getItem())) {
            return false;
        }
        return super.isItemValidForSlot(slot, itemstack);
    }
}

