/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.common;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class SpoolRepairRecipe
implements IRecipe {
    ItemStack spool;
    ItemStack wire;

    public SpoolRepairRecipe(ItemStack spool, ItemStack wire) {
        this.spool = spool.copy();
        this.spool.setItemDamage(256);
        this.wire = wire.copy();
    }

    public boolean matches(InventoryCrafting inventorycrafting, World world) {
        int invLength = inventorycrafting.getSizeInventory();
        boolean foundSpool = false;
        int countWire = 0;
        for (int i = 0; i < invLength; ++i) {
            ItemStack tmpStack = inventorycrafting.getStackInSlot(i);
            if (tmpStack instanceof ItemStack) {
                if (tmpStack.getItem() == this.spool.getItem()) {
                    if (foundSpool) {
                        return false;
                    }
                    foundSpool = true;
                } else if (tmpStack.getItem() == this.wire.getItem() && tmpStack.getItemDamage() == this.wire.getItemDamage()) {
                    ++countWire;
                } else {
                    return false;
                }
            }
            if (countWire <= 0 || !foundSpool) continue;
            return true;
        }
        return false;
    }

    public ItemStack getCraftingResult(InventoryCrafting inventorycrafting) {
        int invLength = inventorycrafting.getSizeInventory();
        ItemStack newSpool = null;
        int countWire = 0;
        for (int i = 0; i < invLength; ++i) {
            ItemStack tmpStack = inventorycrafting.getStackInSlot(i);
            if (!(tmpStack instanceof ItemStack)) continue;
            if (tmpStack.getItem() == this.spool.getItem()) {
                newSpool = tmpStack.copy();
                continue;
            }
            if (tmpStack.getItem() != this.wire.getItem() || tmpStack.getItemDamage() != this.wire.getItemDamage()) continue;
            ++countWire;
        }
        if (countWire > 0 && newSpool != null) {
            newSpool.setItemDamage(newSpool.getItemDamage() - countWire);
        }
        return newSpool;
    }

    public int getRecipeSize() {
        return 9;
    }

    public ItemStack getRecipeOutput() {
        return this.spool.copy();
    }
}

