/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mantle.world.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tmechworks.blocks.logic.SignalBusLogic;
import tmechworks.client.block.SignalBusRender;
import tmechworks.common.MechContent;
import tmechworks.lib.TMechworksRegistry;
import tmechworks.lib.multiblock.IMultiblockMember;

public class SignalBus
extends Block
implements ITileEntityProvider {
    public static int HITBOXES = 6;
    public IIcon[] icons;
    public String[] textureNames = new String[]{"signalbus"};

    public SignalBus() {
        super(Material.circuits);
        this.setHardness(0.1f);
        this.setResistance(1.0f);
        this.setStepSound(soundTypeMetal);
        this.setCreativeTab(TMechworksRegistry.Mechworks);
    }

    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int tileX, int tileY, int tileZ) {
        TileEntity te = world.getTileEntity(tileX, tileY, tileZ);
        if (te instanceof SignalBusLogic && ((SignalBusLogic)te).getMultiblockMaster() != null) {
            ((SignalBusLogic)te).getMultiblockMaster().detachBlock((IMultiblockMember)te, false);
        }
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block block) {
        if (block == this) {
            return;
        }
        super.onNeighborBlockChange(world, x, y, z, block);
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof SignalBusLogic) {
            Random rand = new Random();
            int dropBus = ((SignalBusLogic)te).checkUnsupportedSides();
            if (dropBus > 0) {
                if (((SignalBusLogic)te).checkShouldDestroy()) {
                    WorldHelper.setBlockToAir((World)world, (int)x, (int)y, (int)z);
                }
                ItemStack tempStack = new ItemStack(MechContent.signalBus, dropBus, 0);
                float jumpX = rand.nextFloat() * 0.8f + 0.1f;
                float jumpY = rand.nextFloat() * 0.8f + 0.1f;
                float jumpZ = rand.nextFloat() * 0.8f + 0.1f;
                EntityItem entityitem = new EntityItem(world, (double)((float)x + jumpX), (double)((float)y + jumpY), (double)((float)z + jumpZ), tempStack);
                float offset = 0.05f;
                entityitem.motionX = (float)rand.nextGaussian() * offset;
                entityitem.motionY = (float)rand.nextGaussian() * offset + 0.2f;
                entityitem.motionZ = (float)rand.nextGaussian() * offset;
                world.spawnEntityInWorld((Entity)entityitem);
                world.markBlockForUpdate(x, y, z);
            }
        }
    }

    public void onBlockAdded(World world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te != null && te instanceof SignalBusLogic) {
            ((SignalBusLogic)te).onBlockAdded(world, x, y, z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int metadata) {
        return this.icons[0];
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.icons = new IIcon[this.textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.registerIcon("tmechworks:" + this.textureNames[i]);
        }
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public int getRenderType() {
        return SignalBusRender.renderID;
    }

    public void addCollisionBoxesToList(World world, int x, int y, int z, AxisAlignedBB collisionTest, List collisionBoxList, Entity entity) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof SignalBusLogic) {
            for (AxisAlignedBB aabb : SignalBus.getBoxes((SignalBusLogic)te)) {
                if (aabb == null) continue;
                aabb = AxisAlignedBB.getBoundingBox((double)aabb.minX, (double)aabb.minY, (double)aabb.minZ, (double)aabb.maxX, (double)aabb.maxY, (double)aabb.maxZ);
                aabb.minX += (double)x;
                aabb.minY += (double)y;
                aabb.minZ += (double)z;
                aabb.maxX += (double)x;
                aabb.maxY += (double)y;
                aabb.maxZ += (double)z;
                if (!collisionTest.intersectsWith(aabb)) continue;
                collisionBoxList.add(aabb);
            }
        } else {
            super.addCollisionBoxesToList(world, x, y, z, collisionTest, collisionBoxList, entity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess par1iBlockAccess, int par2, int par3, int par4, int par5) {
        return true;
    }

    public MovingObjectPosition collisionRayTrace(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof SignalBusLogic) {
            MovingObjectPosition closest = null;
            AxisAlignedBB[] boxes = SignalBus.getBoxes((SignalBusLogic)te);
            double closestCalc = Double.MAX_VALUE;
            double hitDistance = 0.0;
            for (int i = 0; i < boxes.length; ++i) {
                if (boxes[i] == null) continue;
                this.setBlockBounds((float)boxes[i].minX, (float)boxes[i].minY, (float)boxes[i].minZ, (float)boxes[i].maxX, (float)boxes[i].maxY, (float)boxes[i].maxZ);
                MovingObjectPosition hit = super.collisionRayTrace(world, x, y, z, start, end);
                if (hit == null || !((hitDistance = start.distanceTo(hit.hitVec)) < closestCalc)) continue;
                closestCalc = hitDistance;
                closest = hit;
            }
            return closest;
        }
        return null;
    }

    private static AxisAlignedBB[] getBoxes(SignalBusLogic logic) {
        double maxZ;
        double maxY;
        double maxX;
        double minZ;
        double minY;
        double minX;
        boolean[] renderDir;
        boolean[] corners;
        boolean[] connected;
        boolean[] placed = logic.placedSides();
        AxisAlignedBB[] parts = new AxisAlignedBB[HITBOXES];
        boolean didRender = false;
        if (placed[ForgeDirection.DOWN.ordinal()]) {
            connected = logic.connectedSides(ForgeDirection.DOWN);
            corners = logic.getRenderCorners(ForgeDirection.DOWN);
            renderDir = new boolean[]{connected[0] || placed[0] || corners[0], connected[1] || placed[1] || corners[1], connected[2] || placed[2] || corners[2], connected[3] || placed[3] || corners[3], connected[4] || placed[4] || corners[4], connected[5] || placed[5] || corners[5]};
            minX = renderDir[ForgeDirection.WEST.ordinal()] ? BusGeometry.cable_extend_min : BusGeometry.cable_width_min;
            minY = BusGeometry.cable_low_offset;
            minZ = renderDir[ForgeDirection.NORTH.ordinal()] ? BusGeometry.cable_extend_min : BusGeometry.cable_width_min;
            maxX = renderDir[ForgeDirection.EAST.ordinal()] ? BusGeometry.cable_extend_max : BusGeometry.cable_width_max;
            maxY = BusGeometry.cable_low_height;
            maxZ = renderDir[ForgeDirection.SOUTH.ordinal()] ? BusGeometry.cable_extend_max : BusGeometry.cable_width_max;
            parts[0] = AxisAlignedBB.getBoundingBox((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            didRender = true;
        }
        if (placed[ForgeDirection.UP.ordinal()]) {
            connected = logic.connectedSides(ForgeDirection.UP);
            corners = logic.getRenderCorners(ForgeDirection.UP);
            renderDir = new boolean[]{connected[0] || placed[0] || corners[0], connected[1] || placed[1] || corners[1], connected[2] || placed[2] || corners[2], connected[3] || placed[3] || corners[3], connected[4] || placed[4] || corners[4], connected[5] || placed[5] || corners[5]};
            minX = renderDir[ForgeDirection.WEST.ordinal()] ? BusGeometry.cable_extend_min : BusGeometry.cable_width_min;
            minY = BusGeometry.cable_high_offset;
            minZ = renderDir[ForgeDirection.NORTH.ordinal()] ? BusGeometry.cable_extend_min : BusGeometry.cable_width_min;
            maxX = renderDir[ForgeDirection.EAST.ordinal()] ? BusGeometry.cable_extend_max : BusGeometry.cable_width_max;
            maxY = BusGeometry.cable_high_height;
            maxZ = renderDir[ForgeDirection.SOUTH.ordinal()] ? BusGeometry.cable_extend_max : BusGeometry.cable_width_max;
            parts[1] = AxisAlignedBB.getBoundingBox((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            didRender = true;
        }
        if (placed[ForgeDirection.NORTH.ordinal()]) {
            connected = logic.connectedSides(ForgeDirection.NORTH);
            corners = logic.getRenderCorners(ForgeDirection.NORTH);
            renderDir = new boolean[]{connected[0] || placed[0] || corners[0], connected[1] || placed[1] || corners[1], connected[2] || placed[2] || corners[2], connected[3] || placed[3] || corners[3], connected[4] || placed[4] || corners[4], connected[5] || placed[5] || corners[5]};
            minX = renderDir[ForgeDirection.WEST.ordinal()] ? BusGeometry.cable_extend_min : BusGeometry.cable_width_min;
            minY = renderDir[ForgeDirection.DOWN.ordinal()] ? BusGeometry.cable_extend_min : BusGeometry.cable_width_min;
            minZ = BusGeometry.cable_low_offset;
            maxX = renderDir[ForgeDirection.EAST.ordinal()] ? BusGeometry.cable_extend_max : BusGeometry.cable_width_max;
            maxY = renderDir[ForgeDirection.UP.ordinal()] ? BusGeometry.cable_extend_max : BusGeometry.cable_width_max;
            maxZ = BusGeometry.cable_low_height;
            parts[2] = AxisAlignedBB.getBoundingBox((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            didRender = true;
        }
        if (placed[ForgeDirection.SOUTH.ordinal()]) {
            connected = logic.connectedSides(ForgeDirection.SOUTH);
            corners = logic.getRenderCorners(ForgeDirection.SOUTH);
            renderDir = new boolean[]{connected[0] || placed[0] || corners[0], connected[1] || placed[1] || corners[1], connected[2] || placed[2] || corners[2], connected[3] || placed[3] || corners[3], connected[4] || placed[4] || corners[4], connected[5] || placed[5] || corners[5]};
            minX = renderDir[ForgeDirection.WEST.ordinal()] ? BusGeometry.cable_extend_min : BusGeometry.cable_width_min;
            minY = renderDir[ForgeDirection.DOWN.ordinal()] ? BusGeometry.cable_extend_min : BusGeometry.cable_width_min;
            minZ = BusGeometry.cable_high_offset;
            maxX = renderDir[ForgeDirection.EAST.ordinal()] ? BusGeometry.cable_extend_max : BusGeometry.cable_width_max;
            maxY = renderDir[ForgeDirection.UP.ordinal()] ? BusGeometry.cable_extend_max : BusGeometry.cable_width_max;
            maxZ = BusGeometry.cable_high_height;
            parts[3] = AxisAlignedBB.getBoundingBox((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            didRender = true;
        }
        if (placed[ForgeDirection.WEST.ordinal()]) {
            connected = logic.connectedSides(ForgeDirection.WEST);
            corners = logic.getRenderCorners(ForgeDirection.WEST);
            renderDir = new boolean[]{connected[0] || placed[0] || corners[0], connected[1] || placed[1] || corners[1], connected[2] || placed[2] || corners[2], connected[3] || placed[3] || corners[3], connected[4] || placed[4] || corners[4], connected[5] || placed[5] || corners[5]};
            minX = BusGeometry.cable_low_offset;
            minY = renderDir[ForgeDirection.DOWN.ordinal()] ? BusGeometry.cable_extend_min : BusGeometry.cable_width_min;
            minZ = renderDir[ForgeDirection.NORTH.ordinal()] ? BusGeometry.cable_extend_min : BusGeometry.cable_width_min;
            maxX = BusGeometry.cable_low_height;
            maxY = renderDir[ForgeDirection.UP.ordinal()] ? BusGeometry.cable_extend_max : BusGeometry.cable_width_max;
            maxZ = renderDir[ForgeDirection.SOUTH.ordinal()] ? BusGeometry.cable_extend_max : BusGeometry.cable_width_max;
            parts[4] = AxisAlignedBB.getBoundingBox((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            didRender = true;
        }
        if (placed[ForgeDirection.EAST.ordinal()]) {
            connected = logic.connectedSides(ForgeDirection.EAST);
            corners = logic.getRenderCorners(ForgeDirection.EAST);
            renderDir = new boolean[]{connected[0] || placed[0] || corners[0], connected[1] || placed[1] || corners[1], connected[2] || placed[2] || corners[2], connected[3] || placed[3] || corners[3], connected[4] || placed[4] || corners[4], connected[5] || placed[5] || corners[5]};
            minX = BusGeometry.cable_high_offset;
            minY = renderDir[ForgeDirection.DOWN.ordinal()] ? BusGeometry.cable_extend_min : BusGeometry.cable_width_min;
            minZ = renderDir[ForgeDirection.NORTH.ordinal()] ? BusGeometry.cable_extend_min : BusGeometry.cable_width_min;
            maxX = BusGeometry.cable_high_height;
            maxY = renderDir[ForgeDirection.UP.ordinal()] ? BusGeometry.cable_extend_max : BusGeometry.cable_width_max;
            maxZ = renderDir[ForgeDirection.SOUTH.ordinal()] ? BusGeometry.cable_extend_max : BusGeometry.cable_width_max;
            parts[5] = AxisAlignedBB.getBoundingBox((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            didRender = true;
        }
        if (!didRender) {
            minX = BusGeometry.cable_width_min;
            minY = BusGeometry.cable_low_offset;
            minZ = BusGeometry.cable_width_min;
            maxX = BusGeometry.cable_width_max;
            maxY = BusGeometry.cable_low_height;
            maxZ = BusGeometry.cable_width_max;
            parts[0] = AxisAlignedBB.getBoundingBox((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
        }
        return parts;
    }

    private static int closestClicked(EntityPlayer player, double reachDistance, SignalBusLogic terminal, AxisAlignedBB[] parts) {
        int closest = -1;
        Vec3 playerPosition = Vec3.createVectorHelper((double)(player.posX - (double)terminal.xCoord), (double)(player.posY - (double)terminal.yCoord + (double)player.getEyeHeight()), (double)(player.posZ - (double)terminal.zCoord));
        Vec3 playerLook = player.getLookVec();
        Vec3 playerViewOffset = Vec3.createVectorHelper((double)(playerPosition.xCoord + playerLook.xCoord * reachDistance), (double)(playerPosition.yCoord + playerLook.yCoord * reachDistance), (double)(playerPosition.zCoord + playerLook.zCoord * reachDistance));
        double closestCalc = Double.MAX_VALUE;
        double hitDistance = 0.0;
        for (int i = 0; i < parts.length; ++i) {
            MovingObjectPosition hit;
            if (parts[i] == null || (hit = parts[i].calculateIntercept(playerPosition, playerViewOffset)) == null || !((hitDistance = playerPosition.distanceTo(hit.hitVec)) < closestCalc)) continue;
            closestCalc = hitDistance;
            closest = i;
        }
        return closest;
    }

    private static void drawOutlinedBoundingBox(AxisAlignedBB par1AxisAlignedBB) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawing(3);
        tessellator.addVertex(par1AxisAlignedBB.minX, par1AxisAlignedBB.minY, par1AxisAlignedBB.minZ);
        tessellator.addVertex(par1AxisAlignedBB.maxX, par1AxisAlignedBB.minY, par1AxisAlignedBB.minZ);
        tessellator.addVertex(par1AxisAlignedBB.maxX, par1AxisAlignedBB.minY, par1AxisAlignedBB.maxZ);
        tessellator.addVertex(par1AxisAlignedBB.minX, par1AxisAlignedBB.minY, par1AxisAlignedBB.maxZ);
        tessellator.addVertex(par1AxisAlignedBB.minX, par1AxisAlignedBB.minY, par1AxisAlignedBB.minZ);
        tessellator.draw();
        tessellator.startDrawing(3);
        tessellator.addVertex(par1AxisAlignedBB.minX, par1AxisAlignedBB.maxY, par1AxisAlignedBB.minZ);
        tessellator.addVertex(par1AxisAlignedBB.maxX, par1AxisAlignedBB.maxY, par1AxisAlignedBB.minZ);
        tessellator.addVertex(par1AxisAlignedBB.maxX, par1AxisAlignedBB.maxY, par1AxisAlignedBB.maxZ);
        tessellator.addVertex(par1AxisAlignedBB.minX, par1AxisAlignedBB.maxY, par1AxisAlignedBB.maxZ);
        tessellator.addVertex(par1AxisAlignedBB.minX, par1AxisAlignedBB.maxY, par1AxisAlignedBB.minZ);
        tessellator.draw();
        tessellator.startDrawing(1);
        tessellator.addVertex(par1AxisAlignedBB.minX, par1AxisAlignedBB.minY, par1AxisAlignedBB.minZ);
        tessellator.addVertex(par1AxisAlignedBB.minX, par1AxisAlignedBB.maxY, par1AxisAlignedBB.minZ);
        tessellator.addVertex(par1AxisAlignedBB.maxX, par1AxisAlignedBB.minY, par1AxisAlignedBB.minZ);
        tessellator.addVertex(par1AxisAlignedBB.maxX, par1AxisAlignedBB.maxY, par1AxisAlignedBB.minZ);
        tessellator.addVertex(par1AxisAlignedBB.maxX, par1AxisAlignedBB.minY, par1AxisAlignedBB.maxZ);
        tessellator.addVertex(par1AxisAlignedBB.maxX, par1AxisAlignedBB.maxY, par1AxisAlignedBB.maxZ);
        tessellator.addVertex(par1AxisAlignedBB.minX, par1AxisAlignedBB.minY, par1AxisAlignedBB.maxZ);
        tessellator.addVertex(par1AxisAlignedBB.minX, par1AxisAlignedBB.maxY, par1AxisAlignedBB.maxZ);
        tessellator.draw();
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new SignalBusLogic();
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        NBTTagCompound data;
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof SignalBusLogic && (data = itemStack.stackTagCompound) != null && data.hasKey("connectedSide")) {
            ((SignalBusLogic)te).addPlacedSide(data.getInteger("connectedSide"));
            itemStack.stackTagCompound = null;
        }
    }

    public void breakBlock(World world, int x, int y, int z, Block block, int meta) {
        int dropWire = 0;
        Random rand = new Random();
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof SignalBusLogic) {
            float offset;
            EntityItem entityitem;
            float jumpZ;
            float jumpY;
            float jumpX;
            ItemStack tempStack;
            int dropBus = ((SignalBusLogic)te).getDroppedBuses();
            dropWire = ((SignalBusLogic)te).getDroppedWire();
            if (dropBus > 0) {
                tempStack = new ItemStack(MechContent.signalBus, dropBus, 0);
                jumpX = rand.nextFloat() * 0.8f + 0.1f;
                jumpY = rand.nextFloat() * 0.8f + 0.1f;
                jumpZ = rand.nextFloat() * 0.8f + 0.1f;
                entityitem = new EntityItem(world, (double)((float)x + jumpX), (double)((float)y + jumpY), (double)((float)z + jumpZ), tempStack);
                offset = 0.05f;
                entityitem.motionX = (float)rand.nextGaussian() * offset;
                entityitem.motionY = (float)rand.nextGaussian() * offset + 0.2f;
                entityitem.motionZ = (float)rand.nextGaussian() * offset;
                world.spawnEntityInWorld((Entity)entityitem);
            }
            if (dropWire > 0) {
                tempStack = new ItemStack(MechContent.lengthWire, dropWire);
                jumpX = rand.nextFloat() * 0.8f + 0.1f;
                jumpY = rand.nextFloat() * 0.8f + 0.1f;
                jumpZ = rand.nextFloat() * 0.8f + 0.1f;
                entityitem = new EntityItem(world, (double)((float)x + jumpX), (double)((float)y + jumpY), (double)((float)z + jumpZ), tempStack);
                offset = 0.05f;
                entityitem.motionX = (float)rand.nextGaussian() * offset;
                entityitem.motionY = (float)rand.nextGaussian() * offset + 0.2f;
                entityitem.motionZ = (float)rand.nextGaussian() * offset;
                world.spawnEntityInWorld((Entity)entityitem);
            }
            ((SignalBusLogic)te).notifyBreak();
        }
        super.breakBlock(world, x, y, z, block, meta);
    }

    public boolean canPlaceBlockOnSide(World par1World, int par2, int par3, int par4, int par5) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)par5);
        boolean solid = dir == ForgeDirection.DOWN && par1World.isSideSolid(par2, par3 + 1, par4, ForgeDirection.DOWN) || dir == ForgeDirection.UP && par1World.isSideSolid(par2, par3 - 1, par4, ForgeDirection.UP) || dir == ForgeDirection.NORTH && par1World.isSideSolid(par2, par3, par4 + 1, ForgeDirection.NORTH) || dir == ForgeDirection.SOUTH && par1World.isSideSolid(par2, par3, par4 - 1, ForgeDirection.SOUTH) || dir == ForgeDirection.WEST && par1World.isSideSolid(par2 + 1, par3, par4, ForgeDirection.WEST) || dir == ForgeDirection.EAST && par1World.isSideSolid(par2 - 1, par3, par4, ForgeDirection.EAST);
        return solid;
    }

    public boolean canPlaceBlockAt(World par1World, int par2, int par3, int par4) {
        return par1World.isSideSolid(par2 - 1, par3, par4, ForgeDirection.EAST) || par1World.isSideSolid(par2 + 1, par3, par4, ForgeDirection.WEST) || par1World.isSideSolid(par2, par3, par4 - 1, ForgeDirection.SOUTH) || par1World.isSideSolid(par2, par3, par4 + 1, ForgeDirection.NORTH) || par1World.isSideSolid(par2, par3 - 1, par4, ForgeDirection.UP) || par1World.isSideSolid(par2, par3 + 1, par4, ForgeDirection.DOWN);
    }

    public boolean canBlockStay(World par1World, int par2, int par3, int par4) {
        return par1World.isSideSolid(par2 - 1, par3, par4, ForgeDirection.EAST) || par1World.isSideSolid(par2 + 1, par3, par4, ForgeDirection.WEST) || par1World.isSideSolid(par2, par3, par4 - 1, ForgeDirection.SOUTH) || par1World.isSideSolid(par2, par3, par4 + 1, ForgeDirection.NORTH) || par1World.isSideSolid(par2, par3 - 1, par4, ForgeDirection.UP) || par1World.isSideSolid(par2, par3 + 1, par4, ForgeDirection.DOWN);
    }

    public TileEntity createNewTileEntity(World var1, int var2) {
        return new SignalBusLogic();
    }

    public static class BusGeometry {
        public static double cable_width_min = 0.375;
        public static double cable_width_max = 1.0 - cable_width_min;
        public static double cable_low_height = 0.2;
        public static double cable_low_offset = 0.0;
        public static double cable_high_height = 1.0;
        public static double cable_high_offset = 1.0 - cable_low_height;
        public static double cable_extend_min = 0.0;
        public static double cable_extend_max = 1.0;
        public static double cable_corner_min = cable_high_offset - 1.0;
        public static double cable_corner_max = cable_low_height + 1.0;
        public static double zfight = 1.0E-5;
    }
}

