/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import mantle.blocks.abstracts.InventoryBlock;
import mantle.blocks.abstracts.InventoryLogic;
import mantle.blocks.iface.IActiveLogic;
import mantle.blocks.iface.IFacingLogic;
import mantle.common.ComparisonHelper;
import mantle.world.CoordTuple;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tmechworks.TMechworks;
import tmechworks.blocks.logic.AdvancedDrawbridgeLogic;
import tmechworks.blocks.logic.DrawbridgeLogic;
import tmechworks.blocks.logic.FirestarterLogic;
import tmechworks.client.block.MachineRender;
import tmechworks.common.CommonProxy;
import tmechworks.lib.TMechworksRegistry;
import tmechworks.lib.blocks.IDrawbridgeLogicBase;

public class RedstoneMachine
extends InventoryBlock {
    static ArrayList<CoordTuple> directions = new ArrayList(6);

    public RedstoneMachine() {
        super(Material.iron);
        this.setCreativeTab(TMechworksRegistry.Mechworks);
        this.setHardness(12.0f);
        this.setStepSound(soundTypeMetal);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (world.getBlockMetadata(x, y, z) == 0 || world.getBlockMetadata(x, y, z) == 2) {
            ItemStack stack;
            TileEntity logic = world.getTileEntity(x, y, z);
            if (logic != null && logic instanceof DrawbridgeLogic && ((DrawbridgeLogic)logic).getStackInSlot(1) != null && Block.getBlockFromItem((Item)(stack = ((DrawbridgeLogic)logic).getStackInSlot(1)).getItem()) != null) {
                return Block.getBlockFromItem((Item)((DrawbridgeLogic)logic).getStackInSlot(1).getItem()).getLightValue();
            }
            if (logic != null && logic instanceof AdvancedDrawbridgeLogic && ((AdvancedDrawbridgeLogic)logic).camoInventory.getCamoStack() != null && Block.getBlockFromItem((Item)(stack = ((AdvancedDrawbridgeLogic)logic).camoInventory.getCamoStack()).getItem()) != null && ((AdvancedDrawbridgeLogic)logic).getStackInSlot(1) != null) {
                return Block.getBlockFromItem((Item)((AdvancedDrawbridgeLogic)logic).getStackInSlot(1).getItem()).getLightValue();
            }
        }
        return super.getLightValue(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockAccess world, int x, int y, int z) {
        ItemStack stack;
        TileEntity logic = world.getTileEntity(x, y, z);
        if (logic != null && logic instanceof DrawbridgeLogic) {
            ItemStack stack2 = ((DrawbridgeLogic)logic).getStackInSlot(1);
            if (stack2 != null && Block.getBlockFromItem((Item)stack2.getItem()) != null && !ComparisonHelper.areEquivalent((Item)stack2.getItem(), (Block)this)) {
                return Block.getBlockFromItem((Item)stack2.getItem()).colorMultiplier(world, x, y, z);
            }
        } else if (logic != null && logic instanceof AdvancedDrawbridgeLogic && (stack = ((AdvancedDrawbridgeLogic)logic).camoInventory.getCamoStack()) != null && Block.getBlockFromItem((Item)stack.getItem()) != null && !ComparisonHelper.areEquivalent((Item)stack.getItem(), (Block)this)) {
            return Block.getBlockFromItem((Item)stack.getItem()).colorMultiplier(world, x, y, z);
        }
        return 0xFFFFFF;
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        switch (metadata) {
            case 0: {
                return new DrawbridgeLogic();
            }
            case 1: {
                return new FirestarterLogic();
            }
            case 2: {
                return new AdvancedDrawbridgeLogic();
            }
            case 3: {
                DrawbridgeLogic logic = new DrawbridgeLogic();
                logic.setMaximumExtension((byte)64);
                return logic;
            }
        }
        return null;
    }

    public Integer getGui(World world, int x, int y, int z, EntityPlayer entityplayer) {
        int meta = world.getBlockMetadata(x, y, z);
        switch (meta) {
            case 0: 
            case 3: {
                return CommonProxy.drawbridgeID;
            }
            case 2: {
                return CommonProxy.advDrawbridgeID;
            }
        }
        return null;
    }

    public Object getModInstance() {
        return TMechworks.instance;
    }

    public String[] getTextureNames() {
        String[] textureNames = new String[]{"drawbridge_top", "drawbridge_side", "drawbridge_bottom", "drawbridge_top_face", "drawbridge_side_face", "drawbridge_bottom_face", "firestarter_top", "firestarter_side", "firestarter_bottom", "drawbridge_side_advanced", "drawbridge_top_extended", "drawbridge_side_extended", "drawbridge_bottom_extended", "drawbridge_top_face_extended", "drawbridge_side_face_extended", "drawbridge_bottom_face_extended"};
        return textureNames;
    }

    public String getTextureDomain(int textureNameIndex) {
        return "tinker";
    }

    public void registerBlockIcons(IIconRegister iconRegister) {
        String[] textureNames = this.getTextureNames();
        this.icons = new IIcon[textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.registerIcon("tmechworks:machines/" + textureNames[i]);
        }
    }

    public IIcon getIcon(int side, int meta) {
        if (meta == 0) {
            if (side == 5) {
                return this.icons[5];
            }
            return this.icons[this.getTextureIndex(side)];
        }
        if (meta == 1) {
            return this.icons[this.getTextureIndex(side) + 6];
        }
        if (meta == 2) {
            if (side == 5) {
                return this.icons[5];
            }
            return this.icons[this.getTextureIndex(side, true)];
        }
        if (meta == 3) {
            if (side == 5) {
                return this.icons[13];
            }
            return this.icons[this.getTextureIndex(side) + 10];
        }
        return this.icons[0];
    }

    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity logic = world.getTileEntity(x, y, z);
        int direction = logic instanceof IFacingLogic ? (int)((IFacingLogic)logic).getRenderDirection() : 0;
        int meta = world.getBlockMetadata(x, y, z);
        if (meta == 0 || meta == 3) {
            Block block;
            int offset = meta == 0 ? 0 : 10;
            DrawbridgeLogic drawbridge = (DrawbridgeLogic)logic;
            ItemStack stack = drawbridge.getStackInSlot(1);
            if (stack != null && (block = Block.getBlockFromItem((Item)stack.getItem())) != null && block.renderAsNormalBlock()) {
                return block.getIcon(side, stack.getItemDamage());
            }
            if (side == direction) {
                return this.icons[this.getTextureIndex(side) + 3 + offset];
            }
            return this.icons[this.getTextureIndex(side) + offset];
        }
        if (meta == 2) {
            Block block;
            AdvancedDrawbridgeLogic drawbridge = (AdvancedDrawbridgeLogic)logic;
            ItemStack stack = drawbridge.camoInventory.getCamoStack();
            if (stack != null && (block = Block.getBlockFromItem((Item)stack.getItem())) != null && block.renderAsNormalBlock()) {
                return block.getIcon(side, stack.getItemDamage());
            }
            if (side == direction) {
                return this.icons[this.getTextureIndex(side) + 3];
            }
            return this.icons[this.getTextureIndex(side, true)];
        }
        if (meta == 1) {
            if (side == direction) {
                return this.icons[6];
            }
            if (side / 2 == direction / 2) {
                return this.icons[8];
            }
            return this.icons[7];
        }
        return this.icons[0];
    }

    public int getTextureIndex(int side) {
        return this.getTextureIndex(side, false);
    }

    public int getTextureIndex(int side, boolean alt) {
        if (side == 0) {
            return 2;
        }
        if (side == 1) {
            return 0;
        }
        return alt ? 9 : 1;
    }

    public int getRenderType() {
        return MachineRender.model;
    }

    public boolean isFireSource(World world, int x, int y, int z, int metadata, ForgeDirection side) {
        if (metadata == 1) {
            return side == ForgeDirection.UP;
        }
        return false;
    }

    public void getSubBlocks(Item id, CreativeTabs tab, List list) {
        for (int iter = 0; iter < 4; ++iter) {
            list.add(new ItemStack(id, 1, iter));
        }
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block neighborBlockID) {
        IActiveLogic logic = (IActiveLogic)world.getTileEntity(x, y, z);
        IFacingLogic facing = (IFacingLogic)logic;
        int direction = facing.getRenderDirection();
        boolean active = false;
        for (int i = 0; i < 6; ++i) {
            if (direction == i) continue;
            CoordTuple coord = directions.get(i);
            if (this.getIndirectPowerLevelTo(world, x + coord.x, y + coord.y, z + coord.z, i) <= 0 && !this.activeRedstone(world, coord.x, y + coord.y, z + coord.z)) continue;
            active = true;
            break;
        }
        logic.setActive(active);
    }

    public int getIndirectPowerLevelTo(World world, int x, int y, int z, int side) {
        Block i1 = world.getBlock(x, y, z);
        if (i1 == null) {
            return 0;
        }
        if (i1.getMaterial().blocksMovement() && i1.renderAsNormalBlock()) {
            return world.getBlockPowerInput(x, y, z);
        }
        return i1.isProvidingWeakPower((IBlockAccess)world, x, y, z, side);
    }

    boolean activeRedstone(World world, int x, int y, int z) {
        Block wire = world.getBlock(x, y, z);
        if (wire != null && wire == Blocks.redstone_wire) {
            return world.getBlockMetadata(x, y, z) > 0;
        }
        return false;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        player.addExhaustion(0.025f);
        int meta = world.getBlockMetadata(x, y, z);
        if (meta < 4 && meta != 1) {
            ItemStack stack = this.getDrawbridgeBlock(world, x, y, z, meta);
            this.dropDrawbridgeLogic(world, x, y, z, stack);
        }
        return world.setBlockToAir(x, y, z);
    }

    private ItemStack getDrawbridgeBlock(World world, int x, int y, int z, int meta) {
        IDrawbridgeLogicBase drawbridge;
        ItemStack stack = new ItemStack((Block)this, 1, meta);
        InventoryLogic logic = (InventoryLogic)world.getTileEntity(x, y, z);
        NBTTagCompound tag = new NBTTagCompound();
        ItemStack camo = null;
        boolean hasTag = false;
        if (meta == 0 || meta == 3) {
            ItemStack contents = logic.getStackInSlot(0);
            if (contents != null) {
                NBTTagCompound contentTag = new NBTTagCompound();
                contents.writeToNBT(contentTag);
                tag.setTag("Contents", (NBTBase)contentTag);
                hasTag = true;
            }
            camo = logic.getStackInSlot(1);
        } else if (meta == 2) {
            AdvancedDrawbridgeLogic advDrawbridge = (AdvancedDrawbridgeLogic)logic;
            camo = advDrawbridge.camoInventory.getCamoStack();
            for (int i = 1; i <= 16; ++i) {
                ItemStack slot = logic.getStackInSlot(i - 1);
                if (slot == null) continue;
                NBTTagCompound contentTag = new NBTTagCompound();
                slot.writeToNBT(contentTag);
                tag.setTag("Slot" + i, (NBTBase)contentTag);
                hasTag = true;
            }
        }
        if (camo != null) {
            NBTTagCompound camoTag = new NBTTagCompound();
            camo.writeToNBT(camoTag);
            tag.setTag("Camoflauge", (NBTBase)camoTag);
            hasTag = true;
        }
        if ((drawbridge = (IDrawbridgeLogicBase)logic).getPlacementDirection() != 4) {
            tag.setByte("Placement", drawbridge.getPlacementDirection());
            hasTag = true;
        }
        if (hasTag) {
            stack.setTagCompound(tag);
        }
        return stack;
    }

    protected void dropDrawbridgeLogic(World world, int x, int y, int z, ItemStack stack) {
        if (!world.isRemote && world.getGameRules().getGameRuleBooleanValue("doTileDrops")) {
            float f = 0.7f;
            double d0 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, stack);
            entityitem.delayBeforeCanPickup = 10;
            world.spawnEntityInWorld((Entity)entityitem);
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        Item id = this.getItem(world, x, y, z);
        if (id == null) {
            return null;
        }
        int meta = this.getDamageValue(world, x, y, z);
        if (meta != 1 && meta < 4) {
            return this.getDrawbridgeBlock(world, x, y, z, meta);
        }
        return new ItemStack(id, 1, meta);
    }

    public void harvestBlock(World world, EntityPlayer player, int x, int y, int z, int meta) {
        if (meta == 1 || meta >= 4) {
            super.harvestBlock(world, player, x, y, z, meta);
        }
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase living, ItemStack stack) {
        super.onBlockPlacedBy(world, x, y, z, living, stack);
        if (stack.hasTagCompound()) {
            int meta = stack.getItemDamage();
            if (meta == 0 || meta == 3) {
                NBTTagCompound camoTag;
                DrawbridgeLogic logic = (DrawbridgeLogic)world.getTileEntity(x, y, z);
                NBTTagCompound contentTag = stack.getTagCompound().getCompoundTag("Contents");
                if (contentTag != null) {
                    ItemStack contents = ItemStack.loadItemStackFromNBT((NBTTagCompound)contentTag);
                    logic.setInventorySlotContents(0, contents);
                }
                if ((camoTag = stack.getTagCompound().getCompoundTag("Camoflauge")) != null) {
                    ItemStack camoflauge = ItemStack.loadItemStackFromNBT((NBTTagCompound)camoTag);
                    logic.setInventorySlotContents(1, camoflauge);
                }
                if (stack.getTagCompound().hasKey("Placement")) {
                    logic.setPlacementDirection(stack.getTagCompound().getByte("Placement"));
                }
            } else if (meta == 2) {
                AdvancedDrawbridgeLogic logic = (AdvancedDrawbridgeLogic)world.getTileEntity(x, y, z);
                for (int i = 1; i <= 16; ++i) {
                    NBTTagCompound contentTag = stack.getTagCompound().getCompoundTag("Slot" + i);
                    if (contentTag == null) continue;
                    ItemStack contents = ItemStack.loadItemStackFromNBT((NBTTagCompound)contentTag);
                    logic.setInventorySlotContents(i - 1, contents);
                    logic.setBufferSlotContents(i - 1, contents);
                }
                NBTTagCompound camoTag = stack.getTagCompound().getCompoundTag("Camoflauge");
                if (camoTag != null) {
                    ItemStack camoflauge = ItemStack.loadItemStackFromNBT((NBTTagCompound)camoTag);
                    logic.camoInventory.setInventorySlotContents(0, camoflauge);
                }
                if (stack.getTagCompound().hasKey("Placement")) {
                    logic.setPlacementDirection(stack.getTagCompound().getByte("Placement"));
                }
            }
        }
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return false;
    }

    static {
        directions.add(new CoordTuple(0.0, -1.0, 0.0));
        directions.add(new CoordTuple(0.0, 1.0, 0.0));
        directions.add(new CoordTuple(0.0, 0.0, -1.0));
        directions.add(new CoordTuple(0.0, 0.0, 1.0));
        directions.add(new CoordTuple(-1.0, 0.0, 0.0));
        directions.add(new CoordTuple(1.0, 0.0, 0.0));
    }
}

