/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.inventory;

import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import tmechworks.blocks.logic.AdvancedDrawbridgeLogic;
import tmechworks.client.gui.AdvDrawbridgeGui;
import tmechworks.inventory.DrawbridgeSlot;
import tmechworks.inventory.SlotOpaqueBlocksOnly;
import tmechworks.lib.TMechworksRegistry;

public class AdvancedDrawbridgeContainer
extends Container {
    public AdvancedDrawbridgeLogic logic;
    public int progress = 0;
    public int fuel = 0;
    public int fuelGague = 0;
    private AdvDrawbridgeGui gui = null;

    public AdvancedDrawbridgeContainer(InventoryPlayer inventoryplayer, AdvancedDrawbridgeLogic logic) {
        this.logic = logic;
        this.addContainerSlots(logic);
        this.bindPlayerInventory(inventoryplayer);
        this.updateContainerSlots();
    }

    public AdvancedDrawbridgeContainer(InventoryPlayer inventoryplayer, AdvancedDrawbridgeLogic logic, AdvDrawbridgeGui gui) {
        this.logic = logic;
        this.gui = gui;
        this.addContainerSlots(logic);
        this.bindPlayerInventory(inventoryplayer);
        this.updateContainerSlots();
    }

    public void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int column;
        for (column = 0; column < 3; ++column) {
            for (int row = 0; row < 9; ++row) {
                this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, row + column * 9 + 9, 8 + row * 18, 84 + column * 18));
            }
        }
        for (column = 0; column < 9; ++column) {
            this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, column, 8 + column * 18, 142));
        }
    }

    public void addContainerSlots(AdvancedDrawbridgeLogic logic) {
        this.addSlotToContainer(new SlotOpaqueBlocksOnly((IInventory)logic.camoInventory, 0, 35, 36));
        for (int i = 0; i < logic.getSizeInventory(); ++i) {
            int x = i < 8 ? 10 + 20 * i : 10 + 20 * (i - 8);
            int y = 35 + (int)Math.floor(i / 8) * 18 + (i < 8 ? 0 : 1);
            this.addSlotToContainer(new DrawbridgeSlot((IInventory)logic, i, x, y, logic));
        }
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        return this.logic.isUseableByPlayer(entityplayer);
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int slotID) {
        ItemStack stack = null;
        Slot slot = (Slot)this.inventorySlots.get(slotID);
        if (slot != null && slot.getHasStack()) {
            ItemStack slotStack = slot.getStack();
            stack = slotStack.copy();
            if (slotID < this.logic.getSizeInventory()) {
                if (!this.mergeItemStack(slotStack, this.logic.getSizeInventory(), this.inventorySlots.size(), true)) {
                    return null;
                }
            } else {
                return null;
            }
            if (slotStack.stackSize == 0) {
                slot.putStack((ItemStack)null);
            } else {
                slot.onSlotChanged();
            }
        }
        return stack;
    }

    public void updateContainerSlots() {
        if (this.gui == null) {
            return;
        }
        if (this.gui.isGuiExpanded) {
            Iterator i1 = this.inventorySlots.iterator();
            int index = 0;
            while (i1.hasNext()) {
                Slot sl = (Slot)i1.next();
                if (index == 0) {
                    sl.xDisplayPosition = -1000;
                    sl.yDisplayPosition = -1000;
                } else if (sl instanceof DrawbridgeSlot) {
                    sl.xDisplayPosition = index - 1 < 8 ? 10 + 20 * (index - 1) : 10 + 20 * (index - 1 - 8);
                    sl.yDisplayPosition = 35 + (int)Math.floor((index - 1) / 8) * 18 + (index - 1 < 8 ? 0 : 1);
                }
                ++index;
            }
        } else {
            Iterator i1 = this.inventorySlots.iterator();
            int index = 0;
            while (i1.hasNext()) {
                Slot sl = (Slot)i1.next();
                if (index == 0) {
                    sl.xDisplayPosition = 35;
                    sl.yDisplayPosition = 36;
                } else if (sl instanceof DrawbridgeSlot) {
                    sl.xDisplayPosition = -1000;
                    sl.yDisplayPosition = -1000;
                }
                ++index;
            }
        }
    }

    public ItemStack slotClick(int par1, int par2, int par3, EntityPlayer par4EntityPlayer) {
        if (this.gui != null && this.gui.containerNeglectMouse) {
            return null;
        }
        return super.slotClick(par1, par2, par3, par4EntityPlayer);
    }

    protected boolean mergeItemStack(ItemStack stack, int startSlotId, int endSlotId, boolean reverseMerge) {
        if (stack == null || !(stack.getItem() instanceof ItemBlock) || this.logic.hasExtended()) {
            return false;
        }
        if (TMechworksRegistry.isItemDBBlacklisted((ItemBlock)stack.getItem())) {
            return false;
        }
        return super.mergeItemStack(stack, startSlotId, endSlotId, reverseMerge);
    }
}

