/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.traits;

import java.util.List;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.potion.TinkerPotion;
import slimeknights.tconstruct.library.traits.AbstractTraitLeveled;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class TraitMagnetic
extends AbstractTraitLeveled {
    public static TinkerPotion Magnetic = new MagneticPotion();

    public TraitMagnetic(int levels) {
        super("magnetic", 0xDDDDDD, 3, levels);
    }

    @Override
    public void afterBlockBreak(ItemStack tool, World world, Block block, BlockPos pos, EntityLivingBase player, boolean wasEffective) {
        ModifierNBT data = new ModifierNBT(TinkerUtil.getModifierTag(tool, this.name));
        Magnetic.apply(player, 30, data.level);
    }

    @Override
    public void onHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damage, boolean isCritical) {
        ModifierNBT data = new ModifierNBT(TinkerUtil.getModifierTag(tool, this.name));
        Magnetic.apply(player, 30, data.level);
    }

    private static class MagneticPotion
    extends TinkerPotion {
        public MagneticPotion() {
            super(Util.getResource("magnetic"), false, false);
        }

        public boolean func_76397_a(int duration, int strength) {
            return (duration & 1) == 0;
        }

        public void func_76394_a(EntityLivingBase entity, int id) {
            double x = entity.field_70165_t;
            double y = entity.field_70163_u;
            double z = entity.field_70161_v;
            double range = 1.8;
            List items = entity.field_70170_p.func_72872_a(EntityItem.class, AxisAlignedBB.func_178781_a((double)(x - (range += (double)((float)entity.func_70660_b((Potion)this).func_76458_c() * 0.3f))), (double)(y - range), (double)(z - range), (double)(x + range), (double)(y + range), (double)(z + range)));
            int pulled = 0;
            for (EntityItem item : items) {
                if (item.func_92059_d() == null || item.func_92059_d().func_77973_b() == null || item.field_70128_L) continue;
                if (pulled > 200) break;
                float strength = 0.07f;
                Vector3d vec = new Vector3d(x, y, z);
                vec.sub((Tuple3d)new Vector3d(item.field_70165_t, item.field_70163_u, item.field_70161_v));
                vec.normalize();
                vec.scale((double)strength);
                item.field_70159_w += vec.x;
                item.field_70181_x += vec.y;
                item.field_70179_y += vec.z;
                ++pulled;
            }
        }
    }
}

