/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.Fluid;
import slimeknights.tconstruct.common.ClientProxy;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.shared.TinkerFluids;

public class FluidsClientProxy
extends ClientProxy {
    @Override
    protected void registerModels() {
        super.registerModels();
        this.registerFluidModels(TinkerFluids.searedStone);
        this.registerFluidModels(TinkerFluids.obsidian);
        this.registerFluidModels(TinkerFluids.clay);
        this.registerFluidModels(TinkerFluids.dirt);
        this.registerFluidModels(TinkerFluids.gold);
        this.registerFluidModels(TinkerFluids.emerald);
        this.registerFluidModels(TinkerFluids.milk);
        this.registerFluidModels(TinkerFluids.blueslime);
        this.registerFluidModels(TinkerFluids.purpleSlime);
        this.registerFluidModels(TinkerFluids.blood);
    }

    @Override
    public void registerFluidModels(Fluid fluid) {
        if (fluid == null) {
            return;
        }
        Block block = fluid.getBlock();
        Item item = Item.func_150898_a((Block)block);
        FluidStateMapper mapper = new FluidStateMapper(fluid);
        ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mapper);
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
    }

    public static class FluidStateMapper
    extends StateMapperBase
    implements ItemMeshDefinition {
        public final Fluid fluid;
        public final ModelResourceLocation location;

        public FluidStateMapper(Fluid fluid) {
            this.fluid = fluid;
            this.location = new ModelResourceLocation(Util.getResource("fluid_block"), fluid.getName());
        }

        protected ModelResourceLocation func_178132_a(IBlockState state) {
            return this.location;
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            return this.location;
        }
    }
}

