/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.gadgets.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.TinkerRegistry;

public class BlockPunji
extends Block {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool NORTHEAST = PropertyBool.func_177716_a((String)"northeast");
    public static final PropertyBool NORTHWEST = PropertyBool.func_177716_a((String)"northwest");

    public BlockPunji() {
        super(Material.field_151585_k);
        this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 0.375f, 0.875f);
        this.func_149672_a(Block.field_149779_h);
        this.func_149647_a((CreativeTabs)TinkerRegistry.tabGadgets);
        this.func_149711_c(3.0f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN));
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{FACING, NORTH, EAST, NORTHEAST, NORTHWEST});
    }

    public IBlockState func_176203_a(int meta) {
        if (meta >= EnumFacing.values().length) {
            meta = EnumFacing.DOWN.ordinal();
        }
        EnumFacing face = EnumFacing.values()[meta];
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)face);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        int off = -facing.ordinal() % 2;
        EnumFacing face1 = EnumFacing.values()[(facing.ordinal() + 2) % 6];
        EnumFacing face2 = EnumFacing.values()[(facing.ordinal() + 4 + off) % 6];
        IBlockState north = worldIn.func_180495_p(pos.func_177972_a(face1));
        IBlockState east = worldIn.func_180495_p(pos.func_177972_a(face2));
        if (north.func_177230_c() == this && north.func_177229_b((IProperty)FACING) == facing) {
            state = state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(true));
        }
        if (east.func_177230_c() == this && east.func_177229_b((IProperty)FACING) == facing) {
            state = state.func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(true));
        }
        IBlockState northeast = worldIn.func_180495_p(pos.func_177972_a(face1).func_177972_a(face2));
        IBlockState northwest = worldIn.func_180495_p(pos.func_177972_a(face1).func_177972_a(face2.func_176734_d()));
        if (northeast.func_177230_c() == this && northeast.func_177229_b((IProperty)FACING) == facing) {
            state = state.func_177226_a((IProperty)NORTHEAST, (Comparable)Boolean.valueOf(true));
        }
        if (northwest.func_177230_c() == this && northwest.func_177229_b((IProperty)FACING) == facing) {
            state = state.func_177226_a((IProperty)NORTHWEST, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing enumfacing = facing.func_176734_d();
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return worldIn.isSideSolid(pos.func_177972_a(side.func_176734_d()), side, true);
    }

    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (!worldIn.isSideSolid(pos.func_177972_a(facing), facing.func_176734_d(), true)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public void func_180654_a(IBlockAccess worldIn, BlockPos pos) {
        EnumFacing facing = (EnumFacing)worldIn.func_180495_p(pos).func_177229_b((IProperty)FACING);
        this.setBlockBoundsBasedOnState(facing);
    }

    public void setBlockBoundsBasedOnState(EnumFacing facing) {
        float h = 0.375f;
        float xMin = 0.1875f;
        float xMax = 1.0f - xMin;
        float zMin = 0.1875f;
        float zMax = 1.0f - zMin;
        float yMin = 0.1875f;
        float yMax = 1.0f - yMin;
        switch (facing) {
            case DOWN: {
                yMin = 0.0f;
                yMax = h;
                break;
            }
            case UP: {
                yMin = 1.0f - h;
                yMax = 1.0f;
                break;
            }
            case SOUTH: {
                zMin = 1.0f - h;
                zMax = 1.0f;
                break;
            }
            case NORTH: {
                zMax = h;
                zMin = 0.0f;
                break;
            }
            case EAST: {
                xMin = 1.0f - h;
                xMax = 1.0f;
                break;
            }
            case WEST: {
                xMax = h;
                xMin = 0.0f;
            }
        }
        this.func_149676_a(xMin, yMin, zMin, xMax, yMax, zMax);
    }

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        this.setBlockBoundsBasedOnState((EnumFacing)state.func_177229_b((IProperty)FACING));
        return super.func_180640_a(worldIn, pos, state);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (entityIn instanceof EntityLiving) {
            float damage = 3.0f;
            if (entityIn.field_70143_R > 0.0f) {
                damage += entityIn.field_70143_R * 1.5f + 2.0f;
            }
            entityIn.func_70097_a(DamageSource.field_76367_g, damage);
            ((EntityLiving)entityIn).func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 20, 1));
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    private static enum Corner implements IStringSerializable
    {
        NONE_UP,
        NORTH_DOWN,
        EAST_UP,
        EAST_DOWN,
        SOUTH_UP,
        SOUTH_DOWN,
        WEST_UP,
        WEST_DOWN;


        public String func_176610_l() {
            return this.toString();
        }
    }
}

