package slimeknights.tconstruct.gadgets.item;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.SlimeBounceHandler;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;

import net.minecraft.item.ItemArmor.ArmorMaterial;
public class ItemSlimeBoots extends ItemArmor {

  public static ArmorMaterial SLIME_MATERIAL = EnumHelper.addArmorMaterial("SLIME", Util.resource("slime"), 0, new int[]{0, 0, 0, 0}, 0);

  public ItemSlimeBoots() {
    super(SLIME_MATERIAL, 0, 3);
    this.func_77637_a(TinkerRegistry.tabGadgets);
    this.func_77625_d(1);
  }

  @Override
  public boolean isValidArmor(ItemStack stack, int armorType, Entity entity) {
    // can be worn as boots
    return armorType == 3;
  }

  // equipping with rightclick
  public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn)
  {
    int slot = 1; // 0 = current item, 1 = feet
    ItemStack itemstack = playerIn.func_71124_b(slot);

    if (itemstack == null)
    {
      playerIn.func_70062_b(slot, itemStackIn.func_77946_l());
      itemStackIn.field_77994_a--;
    }

    return itemStackIn;
  }

  // RUBBERY BOUNCY BOUNCERY WOOOOO
  @SubscribeEvent
  public void onFall(LivingFallEvent event) {
    EntityLivingBase entity = event.entityLiving;
    if(entity == null) {
      return;
    }
    ItemStack feet = entity.func_71124_b(1);
    if(feet == null || feet.func_77973_b() != this) {
      return;
    }

    // thing is wearing slime boots. let's get bouncyyyyy
    if(!entity.func_70093_af() && event.distance > 2) {
      event.damageMultiplier = 0;
      if(entity.field_70170_p.field_72995_K) {
        entity.field_70181_x *= -0.9;
        //entity.motionY = event.distance / 15;
        //entity.motionX = entity.posX - entity.lastTickPosX;
        //entity.motionZ = entity.posZ - entity.lastTickPosZ;
        //event.entityLiving.motionY *= -1.2;
        //event.entityLiving.motionY += 0.8;
        event.entityLiving.field_70160_al = true;
        event.entityLiving.field_70122_E = false;
        double f = 0.91d + 0.04d;
        //System.out.println((entityLiving.worldObj.isRemote ? "client: " : "server: ") + entityLiving.motionX);
        // only slow down half as much when bouncing
        entity.field_70159_w /= f;
        entity.field_70179_y /= f;
      }
      else {
        event.setCanceled(true); // we don't care about previous cancels, since we just bounceeeee
      }
      entity.func_85030_a(Sounds.slime_small, 1f, 1f);
      SlimeBounceHandler.addBounceHandler(entity, entity.field_70181_x);
/*
      if(entity instanceof EntityPlayerMP) {
        ((EntityPlayerMP) entity).playerNetServerHandler
            .sendPacket(new S12PacketEntityVelocity(entity));
      }
      TinkerCommons.potionSlimeBounce.apply(entity, entity.motionY);*/
    }
    else if(!entity.field_70170_p.field_72995_K && entity.func_70093_af()){
      event.damageMultiplier = 0.1f;
    }
  }
}
