package slimeknights.tconstruct.tools.item;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

import java.util.List;

import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.utils.EntityUtil;
import slimeknights.tconstruct.library.utils.ToolBuilder;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;

public class FryPan extends ToolCore {

  public FryPan() {
    super(PartMaterialType.handle(TinkerTools.toolRod),
          PartMaterialType.head(TinkerTools.panHead));

    addCategory(Category.WEAPON);
  }

  @Override
  public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
    addDefaultSubItems(subItems);
    ItemStack tool = getInfiTool("Bane of Pigs");

    if(tool != null) {
      for(int i = 0; i < 25 * 5; i++) {
        TinkerTools.modFiery.apply(tool);
      }

      if(hasValidMaterials(tool)) {
        subItems.add(tool);
      }
    }
  }

  @Override
  public boolean canUseSecondaryItem() {
    return false;
  }

  @Override
  public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int timeLeft) {
    if(world.field_72995_K)
      return;

    float progress = (float)(func_77626_a(stack) - timeLeft)/30f;
    float strength = .1f + 1.5f*progress*progress;

    float range = 3.2f;

    // is the player currently looking at an entity?
    Vec3 eye = new Vec3(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v); // Entity.getPositionEyes
    Vec3 look = player.func_70676_i(1.0f);
    MovingObjectPosition mop = EntityUtil.raytraceEntity(player, eye, look, range, true);

    // nothing hit :(
    if(mop == null) {
      return;
    }

    // we hit something. let it FLYYYYYYYYY
    if(mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
      Entity entity = mop.field_72308_g;
      double x = look.field_72450_a * strength;
      double y = look.field_72448_b/3f * strength + 0.1f + 0.4f * progress;
      double z = look.field_72449_c * strength;

      // bonus damage!
      AttributeModifier modifier = new AttributeModifier(field_111210_e, "Weapon modifier", progress * 5f, 0);


      // we set the entity on fire for the hit if it was fully charged
      // this makes it so it drops cooked stuff.. and it'funny :D
      boolean flamingStrike = progress >= 1f && entity.func_70027_ad();
      if(!flamingStrike) entity.func_70015_d(1);
      player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(modifier);
      ToolHelper.attackEntity(stack, this, player, entity);
      player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(modifier);
      if(!flamingStrike) entity.func_70066_B();

      player.field_70170_p.func_72956_a(player, Sounds.frypan_boing, 1.5f, 0.6f + 0.2f * TConstruct.random.nextFloat());
      entity.func_70024_g(x,y,z);
      if(entity instanceof EntityPlayerMP) {
        ((EntityPlayerMP)entity).field_71135_a.func_147359_a(new S12PacketEntityVelocity(entity));
      }
    }
  }

  @Override
  public boolean dealDamage(ItemStack stack, EntityPlayer player, EntityLivingBase entity, float damage) {
    boolean hit = super.dealDamage(stack, player, entity, damage);
    if(hit) {
      player.field_70170_p.func_72956_a(player, Sounds.frypan_boing, 1.2f,
                                          0.8f + 0.4f * TConstruct.random.nextFloat());
    }
    return hit;
  }

  /**
   * Called when the itemUseDuration runs out
   */
  @Override
  public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityPlayer playerIn) {
    // in our case we want it to also go BANG :D
    //onPlayerStoppedUsing(stack, worldIn, playerIn, 0);
    return stack;
  }

  @Override
  public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
    // has to be done in onUpdate because onTickUsing is too early and gets overwritten. bleh.
    preventSlowDown(entityIn, 0.7f);

    super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
  }

  /**
   * How long it takes to use or consume an item
   */
  public int func_77626_a(ItemStack stack)
  {
    return 5 * 20;
  }

  /**
   * returns the action that specifies what animation to play when the items is being used
   */
  public EnumAction func_77661_b(ItemStack stack)
  {
    return EnumAction.BOW;
  }

  /**
   * Called whenever this item is equipped and the right mouse button is pressed. Args: itemStack, world, entityPlayer
   */
  public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn)
  {
    playerIn.func_71008_a(itemStackIn, this.func_77626_a(itemStackIn));
    return itemStackIn;
  }

  @Override
  public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
    return super.onItemUseFirst(stack, player, world, pos, side, hitX, hitY, hitZ);
  }

  @Override
  public float damagePotential() {
    return 1.0f;
  }

  @Override
  public float knockback() {
    return 2f;
  }

  @Override
  public NBTTagCompound buildTag(List<Material> materials) {
    return buildDefaultTag(materials).get();
  }
}
