/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.traits;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.AbstractMaterialStats;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class TraitStonebound
extends AbstractTrait {
    public TraitStonebound() {
        super("stonebound", EnumChatFormatting.DARK_GRAY);
    }

    private double calcBonus(ItemStack tool) {
        int durability = ToolHelper.getCurrentDurability(tool);
        int maxDurability = ToolHelper.getDurabilityStat(tool);
        return Math.log((double)(maxDurability - durability) / 72.0 + 1.0) * 2.0;
    }

    @Override
    public void miningSpeed(ItemStack tool, PlayerEvent.BreakSpeed event) {
        if (ToolHelper.isToolEffective2(tool, event.state)) {
            event.newSpeed = (float)((double)event.newSpeed + this.calcBonus(tool));
        }
    }

    @Override
    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        String loc = String.format("modifier.%s.extra", this.getModifierIdentifier());
        return ImmutableList.of((Object)Util.translateFormatted(loc, AbstractMaterialStats.df.format(this.calcBonus(tool))));
    }
}

