/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;

public class Scythe
extends ToolCore {
    public static final ImmutableSet<Material> effective_materials = ImmutableSet.of((Object)Material.web, (Object)Material.leaves, (Object)Material.plants, (Object)Material.grass, (Object)Material.vine, (Object)Material.gourd, (Object[])new Material[0]);

    public Scythe() {
        super(PartMaterialType.handle(TinkerTools.toolRod), PartMaterialType.head(TinkerTools.toolRod), PartMaterialType.handle(TinkerTools.toolRod), PartMaterialType.extra(TinkerTools.toughBinding));
    }

    @Override
    public float damagePotential() {
        return 1.3f;
    }

    @Override
    public boolean isEffective(Block block) {
        return effective_materials.contains((Object)block.getMaterial());
    }

    @Override
    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        World world = player.worldObj;
        if (this.isEffective(world.getBlockState(pos).getBlock())) {
            for (BlockPos extraPos : ToolHelper.calcAOEBlocks(itemstack, player.worldObj, player, pos, 5, 5, 5, 4)) {
                if (!this.isEffective(world.getBlockState(extraPos).getBlock())) continue;
                this.breakBlock(itemstack, extraPos, player);
            }
        }
        return super.onBlockStartBreak(itemstack, pos, player);
    }

    private boolean isLeaves(BlockPos pos, EntityPlayer player) {
        return player.worldObj.getBlockState(pos).getBlock().isLeaves((IBlockAccess)player.worldObj, pos);
    }

    protected void breakBlock(ItemStack stack, BlockPos pos, EntityPlayer player) {
        if (EnchantmentHelper.getEnchantmentLevel((int)Enchantment.silkTouch.effectId, (ItemStack)stack) > 0 && ToolHelper.shearBlock(stack, player.worldObj, player, pos)) {
            return;
        }
        ToolHelper.breakExtraBlock(stack, player.worldObj, player, pos, pos);
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        boolean hit = false;
        AxisAlignedBB box = AxisAlignedBB.fromBounds((double)entity.posX, (double)entity.posY, (double)entity.posZ, (double)(entity.posX + 1.0), (double)(entity.posY + 1.0), (double)(entity.posZ + 1.0)).expand(1.0, 1.0, 1.0);
        List entities = player.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)player, box);
        for (Entity target : entities) {
            hit |= ToolHelper.attackEntity(stack, this, player, target);
        }
        return hit;
    }

    @Override
    public boolean canUseSecondaryItem() {
        return false;
    }

    public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer player) {
        BlockPos start = new BlockPos((Entity)player);
        int d = 3;
        int distance = 3;
        for (int xp = start.getX() - d; xp != start.getX() + d; ++xp) {
            for (int yp = start.getY() - d; yp != start.getY() + d; ++yp) {
                for (int zp = start.getZ() - d; zp != start.getZ() + d; ++zp) {
                    BlockPos pos;
                    if (MathHelper.abs_int((int)(xp - start.getX())) + MathHelper.abs_int((int)(yp - start.getY())) + MathHelper.abs_int((int)(zp - start.getZ())) >= distance || !ToolHelper.isToolEffective2(itemStack, world.getBlockState(pos = new BlockPos(xp, yp, zp)))) continue;
                    this.breakBlock(itemStack, pos, player);
                }
            }
        }
        return itemStack;
    }

    @Override
    public int[] getRepairParts() {
        return new int[]{1, 2};
    }

    @Override
    public NBTTagCompound buildTag(List<slimeknights.tconstruct.library.materials.Material> materials) {
        HandleMaterialStats handle = (HandleMaterialStats)materials.get(0).getStatsOrUnknown("handle");
        HeadMaterialStats head = (HeadMaterialStats)materials.get(2).getStatsOrUnknown("head");
        HandleMaterialStats handle2 = (HandleMaterialStats)materials.get(1).getStatsOrUnknown("handle");
        ExtraMaterialStats binding = (ExtraMaterialStats)materials.get(3).getStatsOrUnknown("extra");
        ToolNBT data = new ToolNBT();
        return data.get();
    }
}

