/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.AoeToolCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;

public class Hatchet
extends AoeToolCore {
    public static final ImmutableSet<Material> effective_materials = ImmutableSet.of((Object)Material.wood, (Object)Material.vine, (Object)Material.plants, (Object)Material.gourd, (Object)Material.cactus);

    public Hatchet() {
        this(PartMaterialType.handle(TinkerTools.toolRod), PartMaterialType.head(TinkerTools.axeHead), PartMaterialType.extra(TinkerTools.binding));
    }

    protected Hatchet(PartMaterialType ... requiredComponents) {
        super(requiredComponents);
        this.addCategory(Category.HARVEST);
        this.addCategory(Category.WEAPON);
        this.setHarvestLevel("axe", 0);
    }

    @Override
    public boolean isEffective(Block block) {
        return effective_materials.contains((Object)block.getMaterial()) || ItemAxe.EFFECTIVE_ON.contains(block);
    }

    @Override
    public float damagePotential() {
        return 1.1f;
    }

    @Override
    public float knockback() {
        return 1.3f;
    }

    @Override
    public float getDigSpeed(ItemStack itemstack, IBlockState state) {
        if (state.getBlock().getMaterial() == Material.leaves) {
            return ToolHelper.calcDigSpeed(itemstack, state);
        }
        return super.getDigSpeed(itemstack, state);
    }

    @Override
    public void afterBlockBreak(ItemStack stack, World world, Block block, BlockPos pos, EntityLivingBase player, int damage, boolean wasEffective) {
        if (block.isLeaves((IBlockAccess)world, pos)) {
            damage = 0;
        }
        super.afterBlockBreak(stack, world, block, pos, player, damage, wasEffective);
    }

    @Override
    public NBTTagCompound buildTag(List<slimeknights.tconstruct.library.materials.Material> materials) {
        ToolNBT data = this.buildDefaultTag(materials);
        data.attack += 0.5f;
        return data.get();
    }
}

