/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tinkering;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.IMaterialItem;
import slimeknights.tconstruct.library.utils.TagUtil;

public class MaterialItem
extends Item
implements IMaterialItem {
    public MaterialItem() {
        this.setHasSubtypes(true);
    }

    public void getSubItems(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (Material mat : TinkerRegistry.getAllMaterials()) {
            subItems.add(this.getItemstackWithMaterial(mat));
        }
    }

    @Override
    public String getMaterialID(ItemStack stack) {
        return this.getMaterial((ItemStack)stack).identifier;
    }

    @Override
    public Material getMaterial(ItemStack stack) {
        NBTTagCompound tag = TagUtil.getTagSafe(stack);
        return TinkerRegistry.getMaterial(tag.getString("Material"));
    }

    @Override
    public ItemStack getItemstackWithMaterial(Material material) {
        ItemStack stack = new ItemStack((Item)this);
        NBTTagCompound tag = new NBTTagCompound();
        tag.setString("Material", material.identifier);
        stack.setTagCompound(tag);
        return stack;
    }
}

