/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.traits;

import java.util.ListIterator;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class TraitAutosmelt
extends AbstractTrait {
    public TraitAutosmelt() {
        super("autosmelt", 0xFF5500);
    }

    @Override
    public boolean canApplyTogether(Enchantment enchantment) {
        return enchantment != Enchantment.silkTouch;
    }

    @Override
    public void blockHarvestDrops(ItemStack tool, BlockEvent.HarvestDropsEvent event) {
        if (ToolHelper.isToolEffective(tool, event.state)) {
            ListIterator<ItemStack> iter = event.drops.listIterator();
            while (iter.hasNext()) {
                ItemStack drop = (ItemStack)iter.next();
                ItemStack smelted = FurnaceRecipes.instance().getSmeltingResult(drop);
                if (smelted == null) continue;
                smelted = smelted.copy();
                smelted.stackSize = drop.stackSize;
                int fortune = EnchantmentHelper.getFortuneModifier((EntityLivingBase)event.harvester);
                if (Config.autosmeltlapis && fortune > 0) {
                    smelted.stackSize *= random.nextInt(fortune + 1) + 1;
                }
                iter.set(smelted);
                float xp = FurnaceRecipes.instance().getSmeltingExperience(smelted);
                if (xp < 1.0f && Math.random() < (double)xp) {
                    xp += 1.0f;
                }
                if (!(xp >= 1.0f)) continue;
                event.state.getBlock().dropXpOnBlockBreak(event.world, event.pos, (int)xp);
            }
        }
    }

    @Override
    public void afterBlockBreak(ItemStack tool, World world, Block block, BlockPos pos, EntityLivingBase player, boolean wasEffective) {
        if (world.isRemote && wasEffective) {
            for (int i = 0; i < 3; ++i) {
                world.spawnParticle(EnumParticleTypes.FLAME, (double)pos.getX() + random.nextDouble(), (double)pos.getY() + random.nextDouble(), (double)pos.getZ() + random.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }
}

