/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.tools.TinkerTools;

public class ModBeheading
extends Modifier {
    public ModBeheading() {
        super("beheading");
        this.addAspects(new ModifierAspect.LevelAspect(this, 10), new ModifierAspect.DataAspect((IModifier)this, 1070923), ModifierAspect.freeModifier);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        if (event.source.getEntity() instanceof EntityPlayer) {
            ItemStack item = ((EntityPlayer)event.source.getEntity()).getHeldItem();
            NBTTagCompound tag = TinkerUtil.getModifierTag(item, this.getIdentifier());
            int level = ModifierNBT.readTag((NBTTagCompound)tag).level;
            if (level > 0) {
                ItemStack head;
                if (item.getItem() == TinkerTools.cleaver) {
                    level += 2;
                }
                if ((head = this.getHeadDrop(event.entityLiving)) != null && level > random.nextInt(10)) {
                    EntityItem entityitem = new EntityItem(event.entityLiving.worldObj, event.entityLiving.posX, event.entityLiving.posY, event.entityLiving.posZ, head);
                    entityitem.setDefaultPickupDelay();
                    event.drops.add(entityitem);
                }
            }
        }
    }

    private ItemStack getHeadDrop(EntityLivingBase entity) {
        if (entity instanceof EntitySkeleton) {
            return new ItemStack(Items.skull, 1, ((EntitySkeleton)entity).getSkeletonType());
        }
        if (entity instanceof EntityZombie) {
            return new ItemStack(Items.skull, 1, 2);
        }
        if (entity instanceof EntityCreeper) {
            return new ItemStack(Items.skull, 1, 4);
        }
        if (entity instanceof EntityPlayer) {
            ItemStack head = new ItemStack(Items.skull, 1, 4);
            NBTTagCompound nametag = new NBTTagCompound();
            nametag.setString("SkullOwner", entity.getDisplayName().getFormattedText());
            head.setTagCompound(nametag);
            return head;
        }
        return null;
    }
}

