/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.inventory;

import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.client.CustomTextureCreator;
import slimeknights.tconstruct.library.tinkering.MaterialItem;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IToolPart;

public class SlotToolStationIn
extends Slot {
    public boolean dormant;
    public PartMaterialType restriction;
    public ItemStack icon;
    public Container parent;

    public SlotToolStationIn(IInventory inventoryIn, int index, int xPosition, int yPosition, Container parent) {
        super(inventoryIn, index, xPosition, yPosition);
        this.parent = parent;
    }

    public void onSlotChanged() {
        this.parent.onCraftMatrixChanged(this.inventory);
    }

    public boolean isItemValid(ItemStack stack) {
        if (this.dormant) {
            return false;
        }
        if (this.restriction != null) {
            if (stack != null && stack.getItem() instanceof IToolPart) {
                return this.restriction.isValidItem((IToolPart)stack.getItem());
            }
            return false;
        }
        return super.isItemValid(stack);
    }

    public boolean isDormant() {
        return this.dormant;
    }

    public void activate() {
        this.dormant = false;
    }

    public void deactivate() {
        this.dormant = true;
    }

    public void setRestriction(PartMaterialType restriction) {
        this.restriction = restriction;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateIcon() {
        if (this.restriction != null) {
            for (IToolPart part : this.restriction.getPossibleParts()) {
                if (!(part instanceof MaterialItem)) continue;
                this.icon = ((MaterialItem)((Object)part)).getItemstackWithMaterial(CustomTextureCreator.guiMaterial);
                break;
            }
        } else {
            this.icon = null;
        }
    }
}

