/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import slimeknights.tconstruct.shared.block.BlockTable;

public class TableRecipe
extends ShapedOreRecipe {
    public final List<ItemStack> outputBlocks;

    public TableRecipe(List<ItemStack> variantItems, BlockTable result, int meta, Object ... recipe) {
        super(new ItemStack((Block)result, 1, meta), recipe);
        this.outputBlocks = variantItems;
    }

    public ItemStack getCraftingResult(InventoryCrafting craftMatrix) {
        for (int i = 0; i < craftMatrix.getSizeInventory(); ++i) {
            for (ItemStack ore : this.outputBlocks) {
                ItemStack stack;
                if (!OreDictionary.itemMatches((ItemStack)ore, (ItemStack)(stack = craftMatrix.getStackInSlot(i)), (boolean)false) || Block.getBlockFromItem((Item)stack.getItem()) == null) continue;
                BlockTable block = (BlockTable)Block.getBlockFromItem((Item)this.output.getItem());
                return BlockTable.createItemstack(block, this.output.getItemDamage(), Block.getBlockFromItem((Item)stack.getItem()), stack.getItemDamage());
            }
        }
        return super.getCraftingResult(craftMatrix);
    }

    public ItemStack getRecipeOutput() {
        if (!this.outputBlocks.isEmpty() && this.output != null) {
            ItemStack stack = this.outputBlocks.get(0);
            BlockTable block = (BlockTable)Block.getBlockFromItem((Item)this.output.getItem());
            int meta = stack.getItemDamage();
            if (meta == Short.MAX_VALUE) {
                meta = 0;
            }
            return BlockTable.createItemstack(block, this.output.getItemDamage(), Block.getBlockFromItem((Item)stack.getItem()), meta);
        }
        return super.getRecipeOutput();
    }

    static {
        RecipeSorter.register((String)"tconstruct:table", TableRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"before:minecraft:shaped");
    }
}

