/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.tileentity;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.mantle.tileentity.TileInventory;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.model.ModelHelper;
import slimeknights.tconstruct.shared.block.BlockTable;
import slimeknights.tconstruct.shared.block.PropertyTableItem;
import slimeknights.tconstruct.tools.network.InventorySlotSyncPacket;

public class TileTable
extends TileInventory {
    public static final String FEET_TAG = "textureBlock";
    public static final String FACE_TAG = "facing";
    protected int displaySlot = 0;

    public TileTable() {
        super("", 0, 0);
    }

    public TileTable(String name, int inventorySize) {
        super(name, inventorySize);
    }

    public TileTable(String name, int inventorySize, int maxStackSize) {
        super(name, inventorySize, maxStackSize);
    }

    public IExtendedBlockState writeExtendedBlockState(IExtendedBlockState state) {
        ItemStack stack;
        String texture = this.getTileData().getString("texture");
        if ((texture == null || texture.isEmpty()) && (stack = ItemStack.loadItemStackFromNBT((NBTTagCompound)this.getTileData().getCompoundTag(FEET_TAG))) != null) {
            Block block = Block.getBlockFromItem((Item)stack.getItem());
            texture = ModelHelper.getTextureFromBlock(block, stack.getItemDamage()).getIconName();
            this.getTileData().setString("texture", texture);
        }
        if (texture != null && !texture.isEmpty()) {
            state = state.withProperty((IUnlistedProperty)BlockTable.TEXTURE, (Object)texture);
        }
        EnumFacing facing = this.getFacing();
        state = state.withProperty((IUnlistedProperty)BlockTable.FACING, (Object)facing);
        state = this.setInventoryDisplay(state);
        return state;
    }

    protected IExtendedBlockState setInventoryDisplay(IExtendedBlockState state) {
        ItemStack stack;
        PropertyTableItem.TableItem item;
        PropertyTableItem.TableItems toDisplay = new PropertyTableItem.TableItems();
        if (this.getStackInSlot(this.displaySlot) != null && (item = TileTable.getTableItem(stack = this.getStackInSlot(this.displaySlot))) != null) {
            toDisplay.items.add(item);
        }
        return state.withProperty((IUnlistedProperty)BlockTable.INVENTORY, (Object)toDisplay);
    }

    @SideOnly(value=Side.CLIENT)
    public static PropertyTableItem.TableItem getTableItem(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        IBakedModel model = Minecraft.getMinecraft().getRenderItem().getItemModelMesher().getItemModel(stack);
        if (model == null) {
            return null;
        }
        Object stackModel = model instanceof IFlexibleBakedModel ? (IFlexibleBakedModel)model : new IFlexibleBakedModel.Wrapper(model, DefaultVertexFormats.ITEM);
        PropertyTableItem.TableItem item = new PropertyTableItem.TableItem((IFlexibleBakedModel)stackModel, 0.0f, -0.46875f, 0.0f, 0.8f, -1.5707964f);
        if (stack.getItem() instanceof ItemBlock) {
            item.y = -0.3125f;
            item.s = 0.375f;
            item.r = 0.0f;
        }
        return item;
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound tag = (NBTTagCompound)this.getTileData().copy();
        this.writeToNBT(tag);
        return new S35PacketUpdateTileEntity(this.getPos(), this.getBlockMetadata(), tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTBase facing;
        NBTTagCompound tag = pkt.getNbtCompound();
        NBTBase feet = tag.getTag(FEET_TAG);
        if (feet != null) {
            this.getTileData().setTag(FEET_TAG, feet);
        }
        if ((facing = tag.getTag(FACE_TAG)) != null) {
            this.getTileData().setTag(FACE_TAG, facing);
        }
        this.readFromNBT(tag);
    }

    public void setFacing(EnumFacing face) {
        this.getTileData().setInteger(FACE_TAG, face.getIndex());
    }

    public EnumFacing getFacing() {
        return EnumFacing.getFront((int)this.getTileData().getInteger(FACE_TAG));
    }

    public void updateTextureBlock(NBTTagCompound tag) {
        this.getTileData().setTag(FEET_TAG, (NBTBase)tag);
    }

    public NBTTagCompound getTextureBlock() {
        return this.getTileData().getCompoundTag(FEET_TAG);
    }

    public void setInventorySlotContents(int slot, ItemStack itemstack) {
        if (this.worldObj != null && this.worldObj instanceof WorldServer && !this.worldObj.isRemote && !ItemStack.areItemStacksEqual((ItemStack)itemstack, (ItemStack)this.getStackInSlot(slot))) {
            TinkerNetwork.sendToClients((WorldServer)this.worldObj, this.pos, (AbstractPacket)new InventorySlotSyncPacket(itemstack, slot, this.pos));
        }
        super.setInventorySlotContents(slot, itemstack);
        if (this.getWorld() != null && this.getWorld().isRemote && Config.renderTableItems) {
            Minecraft.getMinecraft().renderGlobal.markBlockForUpdate(this.pos);
        }
    }
}

