/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools;

import net.minecraft.nbt.NBTTagCompound;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;

public class ToolNBT {
    public int durability;
    public int harvestLevel;
    public float attack;
    public float speed;
    public int modifiers;

    public ToolNBT() {
        this.durability = 0;
        this.harvestLevel = 0;
        this.attack = 0.0f;
        this.speed = 0.0f;
    }

    public ToolNBT(NBTTagCompound tag) {
        this.read(tag);
    }

    public ToolNBT head(HeadMaterialStats ... heads) {
        this.durability = 0;
        this.harvestLevel = 0;
        this.attack = 0.0f;
        this.speed = 0.0f;
        for (HeadMaterialStats head : heads) {
            if (head == null) continue;
            this.durability += head.durability;
            this.attack += head.attack;
            this.speed += head.miningspeed;
            if (head.harvestLevel <= this.harvestLevel) continue;
            this.harvestLevel = head.harvestLevel;
        }
        this.durability = Math.max(1, this.durability / heads.length);
        this.attack /= (float)heads.length;
        this.speed /= (float)heads.length;
        return this;
    }

    public ToolNBT extra(ExtraMaterialStats ... extras) {
        int dur = 0;
        for (ExtraMaterialStats extra : extras) {
            if (extra == null) continue;
            dur += extra.extraDurability;
        }
        this.durability += Math.round((float)dur / (float)extras.length);
        return this;
    }

    public ToolNBT handle(HandleMaterialStats ... handles) {
        int dur = 0;
        float modifier = 0.0f;
        for (HandleMaterialStats handle : handles) {
            if (handle == null) continue;
            dur += handle.durability;
            modifier += handle.modifier;
        }
        this.durability = Math.round((float)this.durability * (modifier /= (float)handles.length));
        this.durability += Math.round((float)dur / (float)handles.length);
        this.durability = Math.max(1, this.durability);
        return this;
    }

    public void read(NBTTagCompound tag) {
        this.durability = tag.getInteger("Durability");
        this.harvestLevel = tag.getInteger("HarvestLevel");
        this.attack = tag.getFloat("Attack");
        this.speed = tag.getFloat("MiningSpeed");
        this.modifiers = tag.getInteger("FreeModifiers");
    }

    public void write(NBTTagCompound tag) {
        tag.setInteger("Durability", this.durability);
        tag.setInteger("HarvestLevel", this.harvestLevel);
        tag.setFloat("Attack", this.attack);
        tag.setFloat("MiningSpeed", this.speed);
        tag.setInteger("FreeModifiers", this.modifiers);
    }

    public NBTTagCompound get() {
        NBTTagCompound tag = new NBTTagCompound();
        this.write(tag);
        return tag;
    }
}

